/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customitems;

import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.customitems.CustomItemsConfig;
import com.magmaguy.elitemobs.config.customitems.CustomItemsConfigFields;
import com.magmaguy.elitemobs.items.ScalableItemConstructor;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.items.itemconstructor.ItemConstructor;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomItem {
    private static final HashMap<String, CustomItem> customItems = new HashMap();
    private static final ArrayList<ItemStack> customItemStackList = new ArrayList();
    private static final ArrayList<ItemStack> customItemStackShopList = new ArrayList();
    private static final HashMap<ItemStack, Double> weighedFixedItems = new HashMap();
    private static final HashMap<Integer, ArrayList<ItemStack>> tieredLoot = new HashMap();
    private static final HashMap<Integer, ArrayList<CustomItem>> fixedItems = new HashMap();
    private static final List<CustomItem> scalableItems = new ArrayList<CustomItem>();
    private static final HashMap<Integer, ArrayList<CustomItem>> limitedItems = new HashMap();
    private final CustomItemsConfigFields customItemsConfigFields;
    private final HashMap<Enchantment, Integer> enchantments = new HashMap();
    private final HashMap<String, Integer> customEnchantments = new HashMap();
    private final String permission;
    private List<String> potionEffects = new ArrayList<String>();
    private double dropWeight = 0.0;
    private Scalability scalability;
    private ItemType itemType;
    private int itemLevel = -1;

    public CustomItem(CustomItemsConfigFields customItemsConfigFields) {
        this.customItemsConfigFields = customItemsConfigFields;
        this.itemLevel = customItemsConfigFields.getLevel();
        if (this.itemLevel == 0) {
            this.itemLevel = (int)EliteItemManager.getItemLevel(new ItemStack(customItemsConfigFields.getMaterial()));
        }
        this.permission = customItemsConfigFields.getPermission();
        if (!customItemsConfigFields.isEnabled()) {
            return;
        }
        if (customItemsConfigFields.getMaterial() == null) {
            return;
        }
        this.parseEnchantments();
        this.parsePotionEffects();
        this.parseItemType();
        this.parseItemLevel();
        CustomItem.addCustomItem(customItemsConfigFields.getFilename(), this);
        CustomItem.addCustomItem(this);
        CustomItem.addTieredLoot(this);
        if (this.parseDropWeight()) {
            CustomItem.addFixedItem(this);
            CustomItem.addWeighedFixedItems(this);
            this.scalability = Scalability.FIXED;
            return;
        }
        this.parseScalability();
    }

    public static CustomItem getCustomItem(String fileName) {
        if (!((String)fileName).contains(".yml")) {
            fileName = (String)fileName + ".yml";
        }
        if (!customItems.containsKey(fileName)) {
            return null;
        }
        return customItems.get(fileName);
    }

    private static void addCustomItem(String fileName, CustomItem customItem) {
        customItems.put(fileName, customItem);
    }

    private static void addCustomItem(CustomItem customItem) {
        customItemStackList.add(customItem.generateDefaultsItemStack(null, false, null));
        if (customItem.getItemType().equals((Object)ItemType.UNIQUE)) {
            return;
        }
        customItemStackShopList.add(customItem.generateDefaultsItemStack(null, true, null));
    }

    private static void addWeighedFixedItems(CustomItem customItem) {
        ItemStack itemStack = customItem.generateDefaultsItemStack(null, false, null);
        weighedFixedItems.put(itemStack, customItem.getDropWeight());
    }

    public static void addTieredLoot(CustomItem customItem) {
        ItemStack itemStack = customItem.generateDefaultsItemStack(null, false, null);
        int itemTier = customItem.getItemLevel();
        if (tieredLoot.get(itemTier) == null) {
            tieredLoot.put(itemTier, new ArrayList<ItemStack>(Collections.singletonList(itemStack)));
        } else {
            ArrayList<ItemStack> list = tieredLoot.get(itemTier);
            list.add(itemStack);
            tieredLoot.put(itemTier, list);
        }
    }

    private static void addFixedItem(CustomItem customItem) {
        if (fixedItems.get(customItem.getItemLevel()) == null || fixedItems.get(customItem.getItemLevel()).isEmpty()) {
            fixedItems.put(customItem.getItemLevel(), new ArrayList<CustomItem>(Collections.singletonList(customItem)));
        } else {
            fixedItems.get(customItem.getItemLevel()).add(customItem);
        }
    }

    private static void addLimitedItem(CustomItem customItem) {
        if (limitedItems.get(customItem.getItemLevel()) == null || limitedItems.get(customItem.getItemLevel()).isEmpty()) {
            limitedItems.put(customItem.getItemLevel(), new ArrayList<CustomItem>(Collections.singletonList(customItem)));
        } else {
            limitedItems.get(customItem.getItemLevel()).add(customItem);
        }
    }

    public static void initializeCustomItems() {
        for (CustomItemsConfigFields configFields : CustomItemsConfig.getCustomItems().values()) {
            try {
                new CustomItem(configFields);
            }
            catch (Exception ex) {
                Logger.warn("Failed to generate custom item in file " + configFields.getFilename() + " !");
                ex.printStackTrace();
            }
        }
    }

    public static void regenerateCachedItemStacks() {
        customItemStackList.clear();
        customItemStackShopList.clear();
        tieredLoot.clear();
        weighedFixedItems.clear();
        for (CustomItem customItem : customItems.values()) {
            if (customItem.getCustomItemsConfigFields() == null || !customItem.getCustomItemsConfigFields().isEnabled() || customItem.getCustomItemsConfigFields().getMaterial() == null) continue;
            customItemStackList.add(customItem.generateDefaultsItemStack(null, false, null));
            if (!customItem.getItemType().equals((Object)ItemType.UNIQUE)) {
                customItemStackShopList.add(customItem.generateDefaultsItemStack(null, true, null));
            }
            ItemStack itemStack = customItem.generateDefaultsItemStack(null, false, null);
            int itemTier = customItem.getItemLevel();
            if (tieredLoot.get(itemTier) == null) {
                tieredLoot.put(itemTier, new ArrayList<ItemStack>(Collections.singletonList(itemStack)));
            } else {
                tieredLoot.get(itemTier).add(itemStack);
            }
            if (customItem.getScalability() != Scalability.FIXED || !(customItem.getDropWeight() > 0.0)) continue;
            ItemStack weighedStack = customItem.generateDefaultsItemStack(null, false, null);
            weighedFixedItems.put(weighedStack, customItem.getDropWeight());
        }
    }

    public static int limitItemLevel(Player player, int originalLevel) {
        return originalLevel + 1;
    }

    public Item dropPlayerLoot(Player player, int tier, Location location, EliteEntity eliteEntity) {
        if (!this.permission.isEmpty() && !player.hasPermission(this.permission)) {
            return null;
        }
        Item loot = null;
        int itemTier = CustomItem.limitItemLevel(player, tier);
        switch (this.getScalability().ordinal()) {
            case 1: {
                loot = location.getWorld().dropItem(location, ScalableItemConstructor.constructLimitedItem(itemTier, this, player, eliteEntity));
                break;
            }
            case 2: {
                loot = location.getWorld().dropItem(location, ScalableItemConstructor.constructScalableItem(itemTier + 1, this, player, eliteEntity));
                break;
            }
            case 0: {
                loot = location.getWorld().dropItem(location, this.generateItemStack(this.itemLevel + 1, player, eliteEntity));
            }
        }
        SoulbindEnchantment.addPhysicalDisplay(loot, player);
        loot.setCustomName(loot.getItemStack().getItemMeta().getDisplayName());
        loot.setCustomNameVisible(true);
        return loot;
    }

    private void parseEnchantments() {
        for (String string : this.customItemsConfigFields.getEnchantments()) {
            try {
                Enchantment enchantment;
                String name = string.split(",")[0];
                int level = 1;
                try {
                    level = Integer.parseInt(string.split(",")[1]);
                }
                catch (Exception ex) {
                    Logger.warn("Custom Item Entry " + this.customItemsConfigFields.getFilename() + " has an invalid enchantment entry.");
                    Logger.warn("Enchantment " + name + " is missing a level.");
                    Logger.warn("Reminder - The correct format for these is [enchantmentName],[level]");
                    Logger.warn("The name should follow the API names and the level should be above 0.");
                    Logger.warn("Defaulting " + name + " to level 1.");
                }
                if (CustomEnchantment.isCustomEnchantment(name)) {
                    this.customEnchantments.put(name.toLowerCase(Locale.ROOT), level);
                    continue;
                }
                try {
                    enchantment = Enchantment.getByName((String)name);
                    if (enchantment == null) {
                        throw new Exception("Null enchantment");
                    }
                }
                catch (Exception ex) {
                    Logger.warn("Custom Item Entry " + this.customItemsConfigFields.getFilename() + " has an invalid enchantment entry.");
                    Logger.warn("Enchantment " + name + " is not a valid enchantment. Check the Spigot API for the correct names!");
                    Logger.warn("The invalid entry will be skipped.");
                    continue;
                }
                this.enchantments.put(enchantment, level);
            }
            catch (Exception ex) {
                Logger.warn("Invalid enchantment entry for item " + this.customItemsConfigFields.getFilename());
                Logger.warn("[" + string + "] is not a valid entry and will be ignored.");
                Logger.warn("Reminder - The correct format for these is [enchantmentName],[level]");
                Logger.warn("The name should follow the API names and the level should be above 0.");
            }
        }
    }

    private void parsePotionEffects() {
        this.potionEffects = this.customItemsConfigFields.getPotionEffects();
    }

    private void parseItemType() {
        if (this.customItemsConfigFields.getItemType() == null) {
            this.itemType = ItemType.CUSTOM;
            return;
        }
        this.itemType = this.customItemsConfigFields.getItemType();
    }

    private boolean parseDropWeight() {
        if (this.customItemsConfigFields.getDropWeight() == null) {
            return false;
        }
        if (this.customItemsConfigFields.getDropWeight().equalsIgnoreCase("dynamic")) {
            return false;
        }
        try {
            this.dropWeight = Double.parseDouble(this.customItemsConfigFields.getDropWeight());
            return true;
        }
        catch (Exception e) {
            Logger.warn("Item " + this.customItemsConfigFields.getFilename() + " does not have a valid itemWeight.");
            return false;
        }
    }

    private void parseScalability() {
        if (this.customItemsConfigFields.getScalability() == null) {
            this.scalability = Scalability.SCALABLE;
            return;
        }
        this.scalability = this.customItemsConfigFields.getScalability();
        switch (this.customItemsConfigFields.getScalability().ordinal()) {
            case 0: {
                if (this.itemType.equals((Object)ItemType.UNIQUE)) break;
                CustomItem.addFixedItem(this);
                break;
            }
            case 1: {
                if (this.itemType.equals((Object)ItemType.UNIQUE)) break;
                CustomItem.addLimitedItem(this);
                break;
            }
            case 2: {
                if (this.itemType.equals((Object)ItemType.UNIQUE)) break;
                scalableItems.add(this);
                break;
            }
            default: {
                this.scalability = Scalability.SCALABLE;
                if (!this.itemType.equals((Object)ItemType.UNIQUE)) {
                    scalableItems.add(this);
                }
                Logger.warn("Item " + this.customItemsConfigFields.getFilename() + " does not have a valid scalability type! Defaulting to scalable.");
            }
        }
    }

    private void parseItemLevel() {
        this.itemLevel = (int)Math.round(EliteItemManager.getItemLevel(this.generateDefaultsItemStack(null, false, null)));
    }

    public ItemStack generateDefaultsItemStack(Player player, boolean showItemWorth, EliteEntity eliteEntity) {
        return this.generateDefaultsItemStack(player, showItemWorth, eliteEntity, false);
    }

    public ItemStack generateDefaultsItemStack(Player player, boolean showItemWorth, EliteEntity eliteEntity, boolean bypass) {
        if (!(bypass || player == null || this.permission.isEmpty() || player.hasPermission(this.permission))) {
            return null;
        }
        ItemStack itemStack = ItemConstructor.constructItem(this.itemLevel, this.customItemsConfigFields.getName(), this.customItemsConfigFields.getMaterial(), this.getEnchantments(), this.getCustomEnchantments(), this.getPotionEffects(), this.customItemsConfigFields.getLore(), eliteEntity, player, showItemWorth, this.customItemsConfigFields.getCustomModelID(), this.customItemsConfigFields.getEquipmentModelID(), this.customItemsConfigFields.isSoulbound(), this.getCustomItemsConfigFields().getFilename());
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack generateItemStack(int itemTier, Player player, EliteEntity eliteEntity) {
        ItemStack itemStack = null;
        if (player != null) {
            itemTier = CustomItem.limitItemLevel(player, itemTier);
        }
        switch (this.scalability.ordinal()) {
            case 0: {
                itemStack = this.generateDefaultsItemStack(player, false, eliteEntity);
                break;
            }
            case 1: {
                itemStack = ScalableItemConstructor.constructLimitedItem(itemTier, this, player, eliteEntity);
                break;
            }
            case 2: {
                itemStack = ScalableItemConstructor.constructScalableItem(itemTier, this, player, eliteEntity);
            }
        }
        return itemStack;
    }

    @Generated
    public static HashMap<String, CustomItem> getCustomItems() {
        return customItems;
    }

    @Generated
    public static ArrayList<ItemStack> getCustomItemStackList() {
        return customItemStackList;
    }

    @Generated
    public static ArrayList<ItemStack> getCustomItemStackShopList() {
        return customItemStackShopList;
    }

    @Generated
    public static HashMap<ItemStack, Double> getWeighedFixedItems() {
        return weighedFixedItems;
    }

    @Generated
    public static HashMap<Integer, ArrayList<ItemStack>> getTieredLoot() {
        return tieredLoot;
    }

    @Generated
    public static HashMap<Integer, ArrayList<CustomItem>> getFixedItems() {
        return fixedItems;
    }

    @Generated
    public static List<CustomItem> getScalableItems() {
        return scalableItems;
    }

    @Generated
    public static HashMap<Integer, ArrayList<CustomItem>> getLimitedItems() {
        return limitedItems;
    }

    @Generated
    public CustomItemsConfigFields getCustomItemsConfigFields() {
        return this.customItemsConfigFields;
    }

    @Generated
    public HashMap<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Generated
    public HashMap<String, Integer> getCustomEnchantments() {
        return this.customEnchantments;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public List<String> getPotionEffects() {
        return this.potionEffects;
    }

    @Generated
    public double getDropWeight() {
        return this.dropWeight;
    }

    @Generated
    public Scalability getScalability() {
        return this.scalability;
    }

    @Generated
    public ItemType getItemType() {
        return this.itemType;
    }

    @Generated
    public int getItemLevel() {
        return this.itemLevel;
    }

    public static enum Scalability {
        FIXED,
        LIMITED,
        SCALABLE;

    }

    public static enum ItemType {
        CUSTOM,
        UNIQUE;

    }
}

