/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.magmacore.util.Logger;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SummonWolfEnchantment
extends CustomEnchantment {
    public static final String key = "summon_wolf";

    public SummonWolfEnchantment() {
        super(key, false);
    }

    public static void summonWolf(Player player, ItemStack itemStack) {
        Wolf wolf;
        if (itemStack != null) {
            itemStack.setAmount(itemStack.getAmount() - 1);
        }
        if ((wolf = ThreadLocalRandom.current().nextDouble() < 0.001 ? SummonWolfEnchantment.summonSnoopy(player) : SummonWolfEnchantment.summonGenericWolf(player)) == null) {
            return;
        }
        wolf.setAngry(false);
        wolf.setOwner((AnimalTamer)player);
    }

    private static Wolf summonGenericWolf(Player player) {
        CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity("summonable_wolf.yml");
        customBossEntity.setSpawnLocation(player.getLocation());
        customBossEntity.setLevel(ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getFullPlayerTier(true));
        customBossEntity.spawn(false);
        if (customBossEntity.getCustomBossesConfigFields().getEntityType() != EntityType.WOLF) {
            Logger.warn("snoopy.yml boss file was not set to a wolf entity type! It must be a wolf for the summon mechanic to work correctly!");
            return null;
        }
        return (Wolf)customBossEntity.getLivingEntity();
    }

    private static Wolf summonSnoopy(Player player) {
        CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity("summonable_wolf.yml");
        customBossEntity.setSpawnLocation(player.getLocation());
        customBossEntity.setLevel(ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getFullPlayerTier(true));
        if (customBossEntity.getLivingEntity().getType() != EntityType.WOLF) {
            Logger.warn("snoopy.yml boss file was not set to a wolf entity type! It must be a wolf for the summon mechanic to work correctly!");
            return null;
        }
        return (Wolf)customBossEntity.getLivingEntity();
    }

    private static int getEnchantment(ItemMeta itemMeta) {
        return ItemTagger.getEnchantment(itemMeta, key);
    }

    public static class SummonWolfEnchantmentEvent
    implements Listener {
        private static final Set<UUID> playerCooldowns = new HashSet<UUID>();

        public static void shutdown() {
            playerCooldowns.clear();
        }

        @EventHandler(ignoreCancelled=true)
        public void onRightClick(PlayerInteractEvent event) {
            final UUID playerUUID = event.getPlayer().getUniqueId();
            if (playerCooldowns.contains(playerUUID)) {
                return;
            }
            playerCooldowns.add(playerUUID);
            new BukkitRunnable(this){

                public void run() {
                    playerCooldowns.remove(playerUUID);
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1200L);
            if (!event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                return;
            }
            if (SummonWolfEnchantment.getEnchantment(event.getPlayer().getInventory().getItemInMainHand().getItemMeta()) > 0) {
                SummonWolfEnchantment.summonWolf(event.getPlayer(), event.getPlayer().getInventory().getItemInMainHand());
            }
            if (SummonWolfEnchantment.getEnchantment(event.getPlayer().getInventory().getItemInOffHand().getItemMeta()) > 0) {
                SummonWolfEnchantment.summonWolf(event.getPlayer(), event.getPlayer().getInventory().getItemInOffHand());
            }
        }
    }
}

