/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.config.enchantments.premade.SoulbindConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.EliteItemLore;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.utils.VisualDisplay;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SoulbindEnchantment
extends CustomEnchantment {
    public static final NamespacedKey PRESTIGE_KEY = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "prestige");
    public static String key = "soulbind";
    public static final NamespacedKey SOULBIND_KEY = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key);
    public static boolean isEnabled;

    public SoulbindEnchantment() {
        super(key, true);
    }

    public static ItemStack addEnchantment(ItemStack itemStack, Player player) {
        isEnabled = EnchantmentsConfig.getEnchantment(key + ".yml").isEnabled();
        if (!isEnabled) {
            return null;
        }
        if (itemStack == null || player == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(SOULBIND_KEY, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
        SoulbindEnchantment.setPrestigeLevel(itemMeta, 0);
        itemStack.setItemMeta(itemMeta);
        new EliteItemLore(itemStack, true);
        return itemStack;
    }

    public static void removeEnchantment(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().remove(SOULBIND_KEY);
        itemStack.setItemMeta(itemMeta);
        new EliteItemLore(itemStack, false);
    }

    public static void addPhysicalDisplay(final Item item, final Player player) {
        if (player == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (item == null) {
                    return;
                }
                final TextDisplay soulboundPlayer = VisualDisplay.generateTemporaryTextDisplay(item.getLocation().clone().add(new Vector(0, -50, 0)), ChatColorConverter.convert(SoulbindConfig.hologramStrings.replace("$player", player.getDisplayName())));
                new BukkitRunnable(){
                    final Location lastLocation;
                    int counter;
                    {
                        this.lastLocation = item.getLocation().clone();
                        this.counter = 0;
                    }

                    public void run() {
                        ++this.counter;
                        if (this.counter > 6000 || !item.isValid()) {
                            this.cancel();
                            EntityTracker.unregister((Entity)soulboundPlayer, RemovalReason.EFFECT_TIMEOUT);
                            return;
                        }
                        if (!this.lastLocation.equals((Object)item.getLocation())) {
                            soulboundPlayer.teleport(item.getLocation().clone().add(new Vector(0.0, 0.5, 0.0)));
                        }
                        if (this.counter == 1) {
                            soulboundPlayer.teleport(item.getLocation().clone().add(new Vector(0.0, 0.5, 0.0)));
                        }
                    }
                }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 60L);
    }

    public static boolean isValidSoulbindUser(ItemMeta itemMeta, Player player) {
        if (!isEnabled) {
            return true;
        }
        if (player.hasPermission("elitemobs.soulbind.bypass")) {
            return true;
        }
        if (itemMeta == null) {
            return true;
        }
        if (!itemMeta.getPersistentDataContainer().has(SOULBIND_KEY, PersistentDataType.STRING)) {
            return true;
        }
        return ((String)itemMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key), PersistentDataType.STRING)).equals(player.getUniqueId().toString());
    }

    public static boolean isSoulboundItem(ItemMeta itemMeta) {
        if (!isEnabled) {
            return false;
        }
        if (itemMeta == null) {
            return false;
        }
        return !itemMeta.getPersistentDataContainer().has(SOULBIND_KEY, PersistentDataType.STRING);
    }

    public static Player getSoulboundPlayer(ItemMeta itemMeta) {
        if (!itemMeta.getPersistentDataContainer().has(SOULBIND_KEY, PersistentDataType.STRING)) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString((String)itemMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key), PersistentDataType.STRING));
            return Bukkit.getPlayer((UUID)uuid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean itemHasSoulbindEnchantment(ItemMeta itemMeta) {
        return itemMeta.getPersistentDataContainer().has(SOULBIND_KEY, PersistentDataType.STRING);
    }

    private static void setPrestigeLevel(ItemMeta itemMeta, int prestigeLevel) {
        itemMeta.getPersistentDataContainer().set(PRESTIGE_KEY, PersistentDataType.INTEGER, (Object)prestigeLevel);
    }

    public static int getPrestigeLevel(ItemMeta itemMeta) {
        if (!itemMeta.getPersistentDataContainer().has(SOULBIND_KEY, PersistentDataType.STRING)) {
            return 0;
        }
        int prestige = 0;
        if (itemMeta.getPersistentDataContainer().get(PRESTIGE_KEY, PersistentDataType.INTEGER) != null) {
            prestige = (Integer)itemMeta.getPersistentDataContainer().get(PRESTIGE_KEY, PersistentDataType.INTEGER);
        }
        return prestige;
    }

    public static class SoulbindEnchantmentEvents
    implements Listener {
        @EventHandler(priority=EventPriority.LOWEST)
        public void onPickup(PlayerPickupItemEvent event) {
            if (SoulbindEnchantment.isValidSoulbindUser(event.getItem().getItemStack().getItemMeta(), event.getPlayer())) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

