/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.collateralminecraftchanges.LightningSpawnBypass;
import com.magmaguy.elitemobs.config.enchantments.premade.LightningConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.utils.EventCaller;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class LightningEnchantment
extends CustomEnchantment {
    public static final String key = "lightning";

    public LightningEnchantment() {
        super(key, false);
    }

    public static void playerLightning(Player player, Location location) {
        LightningSpawnBypass.bypass();
        Objects.requireNonNull(location.getWorld()).strikeLightningEffect(location);
        location.getWorld().getNearbyEntities(location, 2.5, 2.5, 2.5).forEach(entity -> {
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity(entity);
            if (eliteEntity == null) {
                return;
            }
            double damage = (double)ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getWeaponLevel(true) * 2.5;
            EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
            EntityDamageByEntityEvent entityDamageByEntityEvent = new EntityDamageByEntityEvent((Entity)player, (Entity)eliteEntity.getLivingEntity(), EntityDamageEvent.DamageCause.CUSTOM, DamageSource.builder((DamageType)DamageType.MOB_ATTACK).build(), damage);
            new EventCaller((Event)entityDamageByEntityEvent);
        });
    }

    public static class LightningEnchantmentEvents
    implements Listener {
        private static final Set<UUID> playersInCooldown = new HashSet<UUID>();

        public static void shutdown() {
            playersInCooldown.clear();
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onEntityDamagedByPlayer(EliteMobDamagedByPlayerEvent event) {
            if (event.getPlayer().hasMetadata("NPC") || !ElitePlayerInventory.playerInventories.containsKey(event.getPlayer().getUniqueId())) {
                return;
            }
            UUID playerUUID = event.getPlayer().getUniqueId();
            if (playersInCooldown.contains(playerUUID)) {
                return;
            }
            double lightningChance = ElitePlayerInventory.playerInventories.get(playerUUID).getLightningChance(true);
            if (lightningChance <= 0.0) {
                return;
            }
            if (lightningChance >= ThreadLocalRandom.current().nextDouble()) {
                return;
            }
            playersInCooldown.add(playerUUID);
            Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> playersInCooldown.remove(playerUUID), (long)LightningConfig.minimumCooldown * 20L);
            LightningEnchantment.playerLightning(event.getPlayer(), event.getEliteMobEntity().getLivingEntity().getLocation());
        }
    }
}

