/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class IceBreakerEnchantment
extends CustomEnchantment {
    public static String key = "ice_breaker";

    public IceBreakerEnchantment() {
        super(key, false);
    }

    private static boolean isValidBlock(Block block) {
        if (block == null) {
            return false;
        }
        Material material = block.getType();
        return material.equals((Object)Material.WATER) || material.equals((Object)Material.ICE) || material.equals((Object)Material.BLUE_ICE) || material.equals((Object)Material.FROSTED_ICE) || material.equals((Object)Material.PACKED_ICE);
    }

    private static void freezeBlocks(Block block, ItemStack itemStack) {
        switch (IceBreakerEnchantment.getCustomEnchantmentLevel(itemStack, key)) {
            case 1: {
                IceBreakerEnchantment.freezeBlocks1(block, itemStack);
                break;
            }
            default: {
                IceBreakerEnchantment.freezeBlocks2(block, itemStack);
            }
        }
    }

    private static void freezeBlocks1(Block block, ItemStack itemStack) {
        IceBreakerEnchantment.parseBlock(block, 0, 0, 0, itemStack);
    }

    private static void freezeBlocks2(Block block, ItemStack itemStack) {
        IceBreakerEnchantment.parseBlock(block, 0, 0, 0, itemStack);
        IceBreakerEnchantment.parseBlock(block, 1, 0, 0, itemStack);
        IceBreakerEnchantment.parseBlock(block, -1, 0, 0, itemStack);
        IceBreakerEnchantment.parseBlock(block, 0, 1, 0, itemStack);
        IceBreakerEnchantment.parseBlock(block, 0, -1, 0, itemStack);
        IceBreakerEnchantment.parseBlock(block, 0, 0, 1, itemStack);
        IceBreakerEnchantment.parseBlock(block, 0, 0, -1, itemStack);
    }

    private static void parseBlock(Block block, int x, int y, int z, ItemStack itemStack) {
        Block newBlock = block.getLocation().clone().add(new Vector(x, y, z)).getBlock();
        if (!newBlock.getType().equals((Object)Material.WATER)) {
            return;
        }
        newBlock.setType(Material.ICE);
        itemStack.setDurability((short)(itemStack.getDurability() + 1));
    }

    public static class IceBreakerEnchantmentEvent
    implements Listener {
        @EventHandler
        public void onInteract(PlayerInteractEvent event) {
            ItemStack mainHandItem = event.getPlayer().getInventory().getItemInMainHand();
            if (!CustomEnchantment.hasCustomEnchantment(mainHandItem, key)) {
                return;
            }
            if (event.getPlayer().rayTraceBlocks(6.0, FluidCollisionMode.ALWAYS) == null) {
                return;
            }
            Block block = event.getPlayer().rayTraceBlocks(6.0, FluidCollisionMode.ALWAYS).getHitBlock();
            if (!IceBreakerEnchantment.isValidBlock(block)) {
                return;
            }
            IceBreakerEnchantment.freezeBlocks(block, mainHandItem);
        }

        @EventHandler
        public void onMine(BlockBreakEvent event) {
            if (event.isCancelled()) {
                return;
            }
            if (!IceBreakerEnchantment.isValidBlock(event.getBlock())) {
                return;
            }
            ItemStack mainHandItem = event.getPlayer().getInventory().getItemInMainHand();
            if (!CustomEnchantment.hasCustomEnchantment(mainHandItem, key)) {
                return;
            }
            IceBreakerEnchantment.freezeBlocks(event.getBlock(), mainHandItem);
            event.getBlock().setType(Material.AIR);
        }
    }
}

