/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items;

import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.items.EliteEnchantments;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffect;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffectContainer;
import com.magmaguy.magmacore.util.Round;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemWorthCalculator {
    public static double determineItemWorth(ItemStack itemStack, Player player) {
        if (itemStack == null || itemStack.getItemMeta() == null || itemStack.getType().equals((Object)Material.AIR)) {
            return 0.0;
        }
        return 1.0 + Round.twoDecimalPlaces(EconomySettingsConfig.getMaterialWorth(itemStack.getType()) + ItemWorthCalculator.getAllEnchantmentValues(itemStack) + ItemWorthCalculator.getAllPotionEffectValues(itemStack.getItemMeta()));
    }

    public static double writeItemWorth(ItemStack itemStack, Player player) {
        return ItemWorthCalculator.determineItemWorth(itemStack, player);
    }

    public static double determineResaleWorth(ItemStack itemStack, Player player) {
        double value = ItemTagger.getItemValue(itemStack);
        value = value == -1.0 ? Round.twoDecimalPlaces(ItemWorthCalculator.determineItemWorth(itemStack, player) * (EconomySettingsConfig.getResaleValue() / 100.0)) : Round.twoDecimalPlaces(value * (EconomySettingsConfig.getResaleValue() / 100.0));
        return value;
    }

    private static double getAllEnchantmentValues(ItemStack itemStack) {
        double value = 0.0;
        for (Enchantment enchantment : itemStack.getEnchantments().keySet()) {
            if (EliteEnchantments.isPotentialEliteEnchantment(enchantment)) {
                if (ItemTagger.getEnchantment(itemStack.getItemMeta(), enchantment.getKey()) == 0) continue;
                value += EnchantmentsConfig.getEnchantment(enchantment).getValue() * (double)ItemTagger.getEnchantment(itemStack.getItemMeta(), enchantment.getKey());
                continue;
            }
            value += EnchantmentsConfig.getEnchantment(enchantment).getValue() * (double)((Integer)itemStack.getEnchantments().get(enchantment)).intValue();
        }
        for (CustomEnchantment customEnchantment : CustomEnchantment.getCustomEnchantmentMap().values()) {
            int enchantmentLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), customEnchantment.key);
            if (enchantmentLevel <= 0) continue;
            value += customEnchantment.getEnchantmentsConfigFields().getValue() * (double)ItemTagger.getEnchantment(itemStack.getItemMeta(), customEnchantment.key);
        }
        return value;
    }

    private static double getAllPotionEffectValues(ItemMeta itemMeta) {
        double value = 0.0;
        for (ElitePotionEffect elitePotionEffect : ElitePotionEffectContainer.getElitePotionEffectContainer(itemMeta, ItemTagger.continuousPotionEffectKey)) {
            value += elitePotionEffect.getValue() * (double)(elitePotionEffect.getPotionEffect().getAmplifier() + 1);
        }
        for (ElitePotionEffect elitePotionEffect : ElitePotionEffectContainer.getElitePotionEffectContainer(itemMeta, ItemTagger.onHitPotionEffectKey)) {
            value += elitePotionEffect.getValue() * (double)(elitePotionEffect.getPotionEffect().getAmplifier() + 1);
        }
        return value;
    }
}

