/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfigFields;
import com.magmaguy.elitemobs.items.EliteEnchantments;
import com.magmaguy.elitemobs.items.EliteItemLore;
import com.magmaguy.elitemobs.items.ItemWorthCalculator;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffect;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffectContainer;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.utils.PersistentVanillaData;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemTagger {
    public static final NamespacedKey eliteMobsItemNamespacedKey = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "EliteMobsItem");
    public static final NamespacedKey customLore = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "CustomLore");
    private static final NamespacedKey ELITE_DAMAGE = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "eliteDamage");
    private static final NamespacedKey ELITE_DEFENSE = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "eliteDefense");
    public static String itemValue = "ItemValue";
    public static NamespacedKey onHitPotionEffectKey = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "onHitPotionEffect");
    public static NamespacedKey continuousPotionEffectKey = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "continuousPotionEffect");
    public static NamespacedKey itemSource = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "itemSource");
    public static NamespacedKey enchantmentCount = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "enchantmentCount");

    public static void registerEliteItem(ItemMeta itemMeta) {
        itemMeta.getPersistentDataContainer().set(eliteMobsItemNamespacedKey, PersistentDataType.BYTE, (Object)1);
    }

    public static void registerEliteItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(eliteMobsItemNamespacedKey, PersistentDataType.BYTE, (Object)1);
        itemStack.setItemMeta(itemMeta);
        new EliteItemLore(itemStack, false);
    }

    public static void registerCustomLore(ItemMeta itemMeta, List<String> lore) {
        StringBuilder parsedLore = new StringBuilder();
        for (int i = 0; i < lore.size(); ++i) {
            parsedLore.append(lore.get(i));
            if (i >= lore.size() - 1) continue;
            parsedLore.append("\n");
        }
        itemMeta.getPersistentDataContainer().set(customLore, PersistentDataType.STRING, (Object)parsedLore.toString());
    }

    public static List<String> getCustomLore(ItemMeta itemMeta) {
        String rawLore = (String)itemMeta.getPersistentDataContainer().get(customLore, PersistentDataType.STRING);
        if (rawLore == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> parsedLore = new ArrayList<String>();
        Collections.addAll(parsedLore, rawLore.split("\n"));
        return parsedLore;
    }

    public static boolean isEliteItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        if (itemStack.getItemMeta().getCustomTagContainer().hasCustomTag(eliteMobsItemNamespacedKey, ItemTagType.BYTE)) {
            return true;
        }
        return itemStack.getItemMeta().getPersistentDataContainer().has(eliteMobsItemNamespacedKey, PersistentDataType.BYTE);
    }

    public static void registerEnchantments(ItemMeta itemMeta, HashMap<Enchantment, Integer> enchantmentMap) {
        for (Enchantment enchantment : enchantmentMap.keySet()) {
            if (!EliteEnchantments.isPotentialEliteEnchantment(enchantment)) continue;
            ItemTagger.registerEnchantment(itemMeta, enchantment.getKey(), enchantmentMap.get(enchantment));
        }
    }

    public static void registerEnchantment(ItemMeta itemMeta, NamespacedKey enchantmentKey, int enchantmentLevel) {
        itemMeta.getPersistentDataContainer().set(enchantmentKey, PersistentDataType.INTEGER, (Object)enchantmentLevel);
    }

    public static void registerCustomEnchantments(ItemMeta itemMeta, HashMap<String, Integer> customEnchantments) {
        for (String subString : customEnchantments.keySet()) {
            ItemTagger.registerCustomEnchantment(itemMeta, subString, customEnchantments.get(subString));
        }
    }

    public static void registerCustomEnchantment(ItemMeta itemMeta, String enchantmentKey, int enchantmentLevel) {
        itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, enchantmentKey), PersistentDataType.INTEGER, (Object)enchantmentLevel);
    }

    public static void registerCustomEnchantment(ItemMeta itemMeta, String enchantmentKey, String uuid) {
        itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, enchantmentKey), PersistentDataType.STRING, (Object)uuid);
    }

    public static int getEnchantment(ItemMeta itemMeta, String enchantmentKey) {
        return ItemTagger.getEnchantment(itemMeta, new NamespacedKey((Plugin)MetadataHandler.PLUGIN, enchantmentKey));
    }

    public static int getEnchantment(ItemMeta itemMeta, NamespacedKey enchantmentKey) {
        if (itemMeta == null) {
            return 0;
        }
        Integer level = (Integer)itemMeta.getPersistentDataContainer().get(enchantmentKey, PersistentDataType.INTEGER);
        if (level == null) {
            Enchantment enchantment = Enchantment.getByKey((NamespacedKey)enchantmentKey);
            if (enchantment != null) {
                return itemMeta.getEnchantLevel(enchantment);
            }
            return 0;
        }
        return level;
    }

    public static boolean hasEnchantment(ItemMeta itemMeta, NamespacedKey enchantmentKey) {
        if (!itemMeta.hasLore()) {
            return false;
        }
        if (itemMeta.getCustomTagContainer().hasCustomTag(enchantmentKey, ItemTagType.INTEGER)) {
            return true;
        }
        return itemMeta.getPersistentDataContainer().has(enchantmentKey, PersistentDataType.INTEGER);
    }

    public static boolean hasKey(ItemStack itemStack, String key) {
        if (itemStack == null) {
            return false;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        return Objects.requireNonNull(itemStack.getItemMeta()).getPersistentDataContainer().has(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key), PersistentDataType.STRING);
    }

    public static boolean hasEnchantment(ItemMeta itemMeta, String keyString) {
        NamespacedKey enchantmentKey = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, keyString);
        if (!itemMeta.hasLore()) {
            return false;
        }
        if (itemMeta.getCustomTagContainer().hasCustomTag(enchantmentKey, ItemTagType.INTEGER)) {
            return true;
        }
        return itemMeta.getPersistentDataContainer().has(enchantmentKey, PersistentDataType.INTEGER);
    }

    public static ArrayList<ElitePotionEffect> getPotionEffects(ItemMeta itemMeta, NamespacedKey namespacedKey) {
        return ElitePotionEffectContainer.getElitePotionEffectContainer(itemMeta, namespacedKey);
    }

    public static void registerItemSource(EliteEntity eliteEntity, ItemMeta itemMeta) {
        if (eliteEntity == null) {
            itemMeta.getPersistentDataContainer().set(itemSource, PersistentDataType.STRING, (Object)ChatColorConverter.convert(ItemSettingsConfig.getShopItemSource()));
            return;
        }
        itemMeta.getPersistentDataContainer().set(itemSource, PersistentDataType.STRING, (Object)ChatColorConverter.convert(ItemSettingsConfig.getMobItemSource().replace("$mob", eliteEntity.getName())));
    }

    public static String getItemSource(ItemMeta itemMeta) {
        return (String)itemMeta.getPersistentDataContainer().get(itemSource, PersistentDataType.STRING);
    }

    public static void writeItemValue(ItemStack itemStack, Player player) {
        PersistentVanillaData.write(itemStack, itemValue, ItemWorthCalculator.writeItemWorth(itemStack, player));
    }

    public static double getItemValue(ItemStack itemStack) {
        return PersistentVanillaData.getDouble(itemStack, itemValue);
    }

    public static double getEliteDamageAttribute(@Nullable ItemStack itemStack) {
        double value = 0.0;
        if (itemStack != null && itemStack.getItemMeta() != null && itemStack.getItemMeta().getPersistentDataContainer().get(ELITE_DAMAGE, PersistentDataType.DOUBLE) != null) {
            return (Double)itemStack.getItemMeta().getPersistentDataContainer().get(ELITE_DAMAGE, PersistentDataType.DOUBLE);
        }
        return value;
    }

    public static double getEliteDamageAttribute(@Nullable Projectile projectile) {
        if (projectile == null) {
            return 0.0;
        }
        if (projectile.getPersistentDataContainer().get(ELITE_DAMAGE, PersistentDataType.DOUBLE) == null) {
            return 0.0;
        }
        return (Double)projectile.getPersistentDataContainer().get(ELITE_DAMAGE, PersistentDataType.DOUBLE);
    }

    public static void setEliteDamageAttribute(ItemStack itemStack, double damageValue) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(ELITE_DAMAGE, PersistentDataType.DOUBLE, (Object)damageValue);
        itemStack.setItemMeta(itemMeta);
    }

    public static void setEliteDamageAttribute(@Nullable Projectile projectile, double damageValue) {
        if (projectile == null) {
            return;
        }
        if (ItemSettingsConfig.isUseEliteEnchantments()) {
            projectile.getPersistentDataContainer().set(ELITE_DAMAGE, PersistentDataType.DOUBLE, (Object)damageValue);
        } else if (projectile.getType().equals((Object)EntityType.ARROW)) {
            Arrow arrow = (Arrow)projectile;
            arrow.setDamage(arrow.getDamage() + damageValue);
        } else if (projectile.getType().equals((Object)EntityType.TRIDENT)) {
            Trident trident = (Trident)projectile;
            trident.setDamage(trident.getDamage() + damageValue);
        }
    }

    public static double getEliteDefenseAttribute(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0;
        }
        if (itemStack.getItemMeta() == null) {
            return 0.0;
        }
        if (itemStack.getItemMeta().getPersistentDataContainer().get(ELITE_DEFENSE, PersistentDataType.DOUBLE) == null) {
            return 0.0;
        }
        return (Double)itemStack.getItemMeta().getPersistentDataContainer().get(ELITE_DEFENSE, PersistentDataType.DOUBLE);
    }

    public static void setEliteDefenseAttribute(@Nullable ItemStack itemStack, double defenseValue) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(ELITE_DEFENSE, PersistentDataType.DOUBLE, (Object)defenseValue);
        itemStack.setItemMeta(itemMeta);
    }

    public static void registerEnchantmentCount(@Nullable ItemMeta itemMeta, int count) {
        if (itemMeta == null) {
            return;
        }
        itemMeta.getPersistentDataContainer().set(enchantmentCount, PersistentDataType.INTEGER, (Object)count);
    }

    public static int getEnchantmentCount(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return 0;
        }
        Integer value = (Integer)itemStack.getItemMeta().getPersistentDataContainer().get(enchantmentCount, PersistentDataType.INTEGER);
        return value == null ? 0 : value;
    }

    public static HashMap<NamespacedKey, Integer> getItemEnchantments(@Nullable ItemStack itemStack) {
        HashMap<NamespacedKey, Integer> itemEnchantmentFilenames = new HashMap<NamespacedKey, Integer>();
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return itemEnchantmentFilenames;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        for (Enchantment enchantment : Enchantment.values()) {
            int enchantmentLevel = ItemTagger.getEnchantment(itemMeta, enchantment.getKey());
            if (enchantmentLevel <= 0) continue;
            itemEnchantmentFilenames.put(enchantment.getKey(), enchantmentLevel);
        }
        for (CustomEnchantment customEnchantment : CustomEnchantment.getCustomEnchantmentMap().values()) {
            int enchantmentLevel = ItemTagger.getEnchantment(itemMeta, customEnchantment.getKey());
            if (enchantmentLevel <= 0) continue;
            itemEnchantmentFilenames.put(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, customEnchantment.getKey()), enchantmentLevel);
        }
        return itemEnchantmentFilenames;
    }

    public static HashMap<EnchantmentsConfigFields, Integer> getItemEnchantmentConfigFields(@Nullable ItemStack itemStack) {
        HashMap<EnchantmentsConfigFields, Integer> itemEnchantmentFilenames = new HashMap<EnchantmentsConfigFields, Integer>();
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return itemEnchantmentFilenames;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        for (Enchantment enchantment : Enchantment.values()) {
            int enchantmentLevel = ItemTagger.getEnchantment(itemMeta, enchantment.getKey());
            if (enchantmentLevel <= 0) continue;
            EnchantmentsConfigFields enchantmentsConfigFields = EnchantmentsConfig.getEnchantment(enchantment.getName().toLowerCase(Locale.ROOT) + ".yml");
            if (enchantmentsConfigFields == null) {
                Logger.warn("Failed to get configuration file for enchantment called " + enchantment.getName().toLowerCase(Locale.ROOT) + ".yml");
                continue;
            }
            itemEnchantmentFilenames.put(enchantmentsConfigFields, enchantmentLevel);
        }
        for (CustomEnchantment customEnchantment : CustomEnchantment.getCustomEnchantmentMap().values()) {
            int enchantmentLevel = ItemTagger.getEnchantment(itemMeta, customEnchantment.getKey());
            if (enchantmentLevel <= 0) continue;
            itemEnchantmentFilenames.put(customEnchantment.getEnchantmentsConfigFields(), enchantmentLevel);
        }
        return itemEnchantmentFilenames;
    }

    @Generated
    public static NamespacedKey getELITE_DAMAGE() {
        return ELITE_DAMAGE;
    }

    @Generated
    public static NamespacedKey getELITE_DEFENSE() {
        return ELITE_DEFENSE;
    }
}

