/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.AdventurersGuildConfig;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GearRestrictionHandler {
    private static final Set<UUID> recentWarnings = new HashSet<UUID>();

    public static void shutdown() {
        recentWarnings.clear();
    }

    public static boolean canEquip(Player player, ItemStack itemStack) {
        if (!AdventurersGuildConfig.isSkillBasedGearRestriction()) {
            return true;
        }
        if (itemStack == null || itemStack.getType().isAir()) {
            return true;
        }
        if (!EliteItemManager.isEliteMobsItem(itemStack)) {
            return true;
        }
        int itemLevel = EliteItemManager.getRoundedItemLevel(itemStack);
        if (itemLevel <= 0) {
            return true;
        }
        if (itemLevel <= 20) {
            return true;
        }
        SkillType skillType = SkillType.fromMaterialIncludingArmor(itemStack.getType());
        if (skillType == null) {
            return true;
        }
        long skillXP = PlayerData.getSkillXP(player.getUniqueId(), skillType);
        int playerSkillLevel = SkillXPCalculator.levelFromTotalXP(skillXP);
        return playerSkillLevel >= itemLevel;
    }

    public static int getEffectiveItemLevel(Player player, ItemStack itemStack) {
        if (!AdventurersGuildConfig.isSkillBasedGearRestriction()) {
            return EliteItemManager.getRoundedItemLevel(itemStack);
        }
        if (!GearRestrictionHandler.canEquip(player, itemStack)) {
            return 0;
        }
        return EliteItemManager.getRoundedItemLevel(itemStack);
    }

    public static void sendRestrictionMessage(Player player, ItemStack itemStack) {
        if (!AdventurersGuildConfig.isSkillBasedGearRestriction()) {
            return;
        }
        SkillType skillType = SkillType.fromMaterialIncludingArmor(itemStack.getType());
        if (skillType == null) {
            return;
        }
        if (recentWarnings.contains(player.getUniqueId())) {
            return;
        }
        recentWarnings.add(player.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> recentWarnings.remove(player.getUniqueId()), 40L);
        int itemLevel = EliteItemManager.getRoundedItemLevel(itemStack);
        long skillXP = PlayerData.getSkillXP(player.getUniqueId(), skillType);
        int playerSkillLevel = SkillXPCalculator.levelFromTotalXP(skillXP);
        String message = AdventurersGuildConfig.getGearRestrictionMessage().replace("$itemLevel", String.valueOf(itemLevel)).replace("$skillLevel", String.valueOf(playerSkillLevel)).replace("$skillType", skillType.getDisplayName());
        player.sendMessage(ChatColorConverter.convert(message));
    }
}

