/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced.dungeons;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfig;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.utility.DungeonUtils;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.instanced.WorldOperationQueue;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.InstancedBossEntity;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.utils.WorldInstantiator;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DynamicDungeonInstance
extends DungeonInstance {
    private final int selectedLevel;

    public DynamicDungeonInstance(ContentPackagesConfigFields contentPackagesConfigFields, Location lobbyLocation, Location startLocation, World world, Player player, String difficultyName, int selectedLevel) {
        super(contentPackagesConfigFields, lobbyLocation, startLocation, world, player, difficultyName);
        this.selectedLevel = selectedLevel;
        this.recalculateLevelSyncForDynamicLevel(selectedLevel);
        new SetBossLevelsTask(this, selectedLevel).runTaskLater((Plugin)MetadataHandler.PLUGIN, 80L);
    }

    public static void setupDynamicDungeon(Player player, String dungeonConfigFieldsString, String difficultyName, int selectedLevel) {
        ContentPackagesConfigFields dynamicDungeonConfigFields = ContentPackagesConfig.getDungeonPackages().get(dungeonConfigFieldsString);
        if (dynamicDungeonConfigFields == null) {
            player.sendMessage("[EliteMobs] Failed to get data for dynamic dungeon " + dungeonConfigFieldsString + "! The dungeon will not start.");
            return;
        }
        if (dynamicDungeonConfigFields.getPermission() != null && !dynamicDungeonConfigFields.getPermission().isEmpty() && !player.hasPermission(dynamicDungeonConfigFields.getPermission())) {
            player.sendMessage("[EliteMobs] You don't have the permission to go to this dungeon!");
            return;
        }
        String instancedWorldName = WorldInstantiator.getNewWorldName(dynamicDungeonConfigFields.getWorldName());
        if (!DynamicDungeonInstance.launchEvent(dynamicDungeonConfigFields, instancedWorldName, player)) {
            return;
        }
        WorldOperationQueue.queueOperation(player, () -> DynamicDungeonInstance.cloneWorldFiles(dynamicDungeonConfigFields, instancedWorldName, player) != null, () -> DynamicDungeonInstance.initializeDynamicWorld(dynamicDungeonConfigFields, instancedWorldName, player, difficultyName, selectedLevel), dynamicDungeonConfigFields.getName());
    }

    protected static DynamicDungeonInstance initializeDynamicWorld(ContentPackagesConfigFields dynamicDungeonConfigFields, String instancedWorldName, Player player, String difficultyName, int selectedLevel) {
        World world = DungeonUtils.loadWorld(instancedWorldName, dynamicDungeonConfigFields.getEnvironment(), dynamicDungeonConfigFields);
        if (world == null) {
            player.sendMessage("[EliteMobs] Failed to load the world! Report this to the dev. The dungeon will not start.");
            return null;
        }
        Location startLocation = ConfigurationLocation.serialize(dynamicDungeonConfigFields.getStartLocationString());
        startLocation.setWorld(world);
        Location lobbyLocation = ConfigurationLocation.serialize(dynamicDungeonConfigFields.getTeleportLocationString());
        if (lobbyLocation != null) {
            lobbyLocation.setWorld(world);
        } else {
            lobbyLocation = startLocation;
        }
        return new DynamicDungeonInstance(dynamicDungeonConfigFields, lobbyLocation, startLocation, world, player, difficultyName, selectedLevel);
    }

    @Override
    public boolean addNewPlayer(Player player) {
        if (!super.addNewPlayer(player)) {
            return false;
        }
        player.sendMessage("[EliteMobs] Dynamic dungeon level set to " + this.selectedLevel + "!");
        return true;
    }

    @Generated
    public int getSelectedLevel() {
        return this.selectedLevel;
    }

    private class SetBossLevelsTask
    extends BukkitRunnable {
        private final DynamicDungeonInstance dynamicDungeonInstance;
        private final int level;

        public SetBossLevelsTask(DynamicDungeonInstance dynamicDungeonInstance2, int level) {
            this.dynamicDungeonInstance = dynamicDungeonInstance2;
            this.level = level;
        }

        public void run() {
            DynamicDungeonInstance.this.getWorld().getEntities().forEach(entity -> {
                InstancedBossEntity boss;
                EliteEntity eliteEntity;
                if (entity instanceof LivingEntity && (eliteEntity = EntityTracker.getEliteMobEntity(entity)) instanceof InstancedBossEntity && (boss = (InstancedBossEntity)eliteEntity).getDungeonInstance() == this.dynamicDungeonInstance) {
                    boss.setEntityLevel(this.level);
                }
            });
        }
    }
}

