/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.utils.VisualDisplay;
import com.magmaguy.magmacore.util.ChatColorConverter;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class InstanceDeathLocation {
    private final MatchInstance matchInstance;
    private Block bannerBlock;
    private Player deadPlayer;
    private Location deathLocation = null;
    private TextDisplay nameTag;
    private TextDisplay livesLeft;
    private TextDisplay instructions;

    protected InstanceDeathLocation(Player player, MatchInstance matchInstance) {
        this.matchInstance = matchInstance;
        if (matchInstance.playerLives.get(player) < 1) {
            return;
        }
        this.deadPlayer = player;
        this.bannerBlock = player.getLocation().getBlock();
        this.findBannerLocation(player.getLocation());
        this.instructions = VisualDisplay.generateTemporaryTextDisplay(this.deathLocation.clone().add(new Vector(0.0, 2.2, 0.0)), ChatColorConverter.convert("&2Punch to rez!"));
        this.nameTag = VisualDisplay.generateTemporaryTextDisplay(this.deathLocation.clone().add(new Vector(0, 2, 0)), player.getDisplayName());
        this.livesLeft = VisualDisplay.generateTemporaryTextDisplay(this.deathLocation.clone().add(new Vector(0.0, 1.8, 0.0)), String.valueOf(matchInstance.playerLives.get(this.deadPlayer)) + " lives left!");
        if (this.deathLocation != null) {
            matchInstance.deathBanners.put(this.bannerBlock, this);
        }
        this.bannerWatchdog();
    }

    private void findBannerLocation(Location location) {
        if (location.getBlock().getType().isAir()) {
            this.setBannerBlock(location);
        } else if (location.getY() < 320.0) {
            this.findBannerLocation(location.add(new Vector(0, 1, 0)));
        }
    }

    private void setBannerBlock(Location location) {
        this.deathLocation = location;
        this.bannerBlock = location.getBlock();
        EntityTracker.addTemporaryBlock(location.getBlock(), -1, Material.RED_BANNER);
    }

    public void clear(boolean resurrect) {
        this.bannerBlock.setType(Material.AIR);
        EntityTracker.unregister((Entity)this.nameTag, RemovalReason.EFFECT_TIMEOUT);
        EntityTracker.unregister((Entity)this.instructions, RemovalReason.EFFECT_TIMEOUT);
        EntityTracker.unregister((Entity)this.livesLeft, RemovalReason.EFFECT_TIMEOUT);
        this.matchInstance.deathBanners.remove(this.bannerBlock);
        if (resurrect) {
            this.matchInstance.revivePlayer(this.deadPlayer, this);
        }
    }

    public void bannerWatchdog() {
        new BukkitRunnable(){

            public void run() {
                if (!InstanceDeathLocation.this.matchInstance.deathBanners.containsKey(InstanceDeathLocation.this.bannerBlock)) {
                    this.cancel();
                    return;
                }
                if (InstanceDeathLocation.this.bannerBlock.getType().equals((Object)Material.RED_BANNER)) {
                    return;
                }
                EntityTracker.unregister((Entity)InstanceDeathLocation.this.nameTag, RemovalReason.EFFECT_TIMEOUT);
                EntityTracker.unregister((Entity)InstanceDeathLocation.this.instructions, RemovalReason.EFFECT_TIMEOUT);
                EntityTracker.unregister((Entity)InstanceDeathLocation.this.livesLeft, RemovalReason.EFFECT_TIMEOUT);
                InstanceDeathLocation.this.findBannerLocation(InstanceDeathLocation.this.deathLocation);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 5L, 5L);
    }

    @Generated
    public Block getBannerBlock() {
        return this.bannerBlock;
    }

    @Generated
    public Player getDeadPlayer() {
        return this.deadPlayer;
    }
}

