/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.entitytracker;

import com.magmaguy.elitemobs.MetadataHandler;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomProjectileData
implements Listener {
    private static final HashMap<Projectile, CustomProjectileData> customProjectileDataHashMap = new HashMap();
    private final Player player;
    private ItemStack projectileShooter = null;
    private Material projectileShooterMaterial = null;

    private CustomProjectileData(Player player, Projectile projectile) {
        this.player = player;
        if (projectile instanceof Trident) {
            Trident trident = (Trident)projectile;
            this.projectileShooter = trident.getItem();
            this.projectileShooterMaterial = Material.TRIDENT;
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() == Material.BOW || player.getInventory().getItemInMainHand().getType() == Material.CROSSBOW) {
            this.projectileShooter = player.getInventory().getItemInMainHand();
            this.projectileShooterMaterial = this.projectileShooter.getType();
        } else if (player.getInventory().getItemInOffHand().getType() == Material.BOW || player.getInventory().getItemInOffHand().getType() == Material.CROSSBOW) {
            this.projectileShooter = player.getInventory().getItemInOffHand();
            this.projectileShooterMaterial = this.projectileShooter.getType();
        }
    }

    public static void shutdown() {
        customProjectileDataHashMap.clear();
    }

    @EventHandler
    public void onPlayerFireProjectile(final ProjectileLaunchEvent event) {
        ProjectileSource projectileSource;
        if (event.getEntity().getShooter() == null || !((projectileSource = event.getEntity().getShooter()) instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        customProjectileDataHashMap.put(event.getEntity(), new CustomProjectileData(player, event.getEntity()));
        new BukkitRunnable(this){

            public void run() {
                customProjectileDataHashMap.remove(event.getEntity());
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 6000L);
    }

    @EventHandler
    public void onArrowLandEvent(final ProjectileHitEvent event) {
        if (customProjectileDataHashMap.containsKey(event.getEntity())) {
            new BukkitRunnable(this){

                public void run() {
                    customProjectileDataHashMap.remove(event.getEntity());
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
        }
    }

    @Generated
    public static HashMap<Projectile, CustomProjectileData> getCustomProjectileDataHashMap() {
        return customProjectileDataHashMap;
    }

    @Generated
    public ItemStack getProjectileShooter() {
        return this.projectileShooter;
    }

    @Generated
    public Material getProjectileShooterMaterial() {
        return this.projectileShooterMaterial;
    }
}

