/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.easyminecraftgoals.v1_21_R1.move;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class Move {
    public static boolean canReach(PathfinderMob pathfinderMob, Location destination) {
        if (pathfinderMob.getNavigation() == null) {
            return true;
        }
        Path path = pathfinderMob.getNavigation().createPath(destination.getX(), destination.getY(), destination.getZ(), 0);
        if (path == null) {
            return true;
        }
        return path.canReach();
    }

    public static boolean simpleMove(PathfinderMob pathfinderMob, double speedModifier, Location destination) {
        Path path = pathfinderMob.getNavigation().createPath(destination.getX(), destination.getY(), destination.getZ(), 0);
        return pathfinderMob.getNavigation().moveTo(path, speedModifier);
    }

    public static void doNotMove(PathfinderMob pathfinderMob) {
        pathfinderMob.getNavigation().moveTo((Entity)pathfinderMob, 0.0);
    }

    public static void universalMove(Mob mob, double speedModifier, Location destination) {
        double speed = mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.75;
        Vec3 movementInTick = new Vec3(destination.getX(), destination.getY(), destination.getZ()).subtract(mob.position());
        movementInTick = movementInTick.normalize().multiply(speedModifier * speed, speedModifier * speed, speedModifier * speed);
        mob.move(MoverType.SELF, movementInTick);
        Move.rotateHead((Entity)mob, destination.toVector(), new Vector(mob.position().x, mob.position().y, mob.position().z));
    }

    private static void rotateHead(Entity entity, Vector destination, Vector currentLocation) {
        Vector newVector = destination.subtract(currentLocation);
        double x = newVector.getX();
        double z = newVector.getZ();
        double targetRot = Math.abs(x) > Math.abs(z) ? (x > 0.0 ? -90.0 : 90.0) : (z > 0.0 ? 0.0 : 180.0);
        double currentRot = entity.getYRot();
        if (currentRot == targetRot) {
            return;
        }
        if (targetRot - currentRot > 0.0) {
            entity.turn(90.0, 0.0);
        } else {
            entity.turn(-90.0, 0.0);
        }
    }

    public static boolean forcedMove(Mob mob, double speedModifier, Location destination) {
        mob.removeFreeWill();
        Move.universalMove(mob, speedModifier, destination);
        return true;
    }
}

