/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.config.DungeonsConfig;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.DungeonBossLockout;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.InstancedBossEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class DungeonBossLockoutHandler
implements Listener {
    public static String getBossIdentifier(InstancedBossEntity boss) {
        String filename = boss.getCustomBossesConfigFields().getFilename();
        if (boss.getSpawnLocation() != null) {
            int x = boss.getSpawnLocation().getBlockX();
            int y = boss.getSpawnLocation().getBlockY();
            int z = boss.getSpawnLocation().getBlockZ();
            return filename + ":" + x + "," + y + "," + z;
        }
        if (boss.getLocation() != null) {
            int x = boss.getLocation().getBlockX();
            int y = boss.getLocation().getBlockY();
            int z = boss.getLocation().getBlockZ();
            return filename + ":" + x + "," + y + "," + z;
        }
        return filename + ":unknown";
    }

    public static Set<Player> processLockouts(InstancedBossEntity boss, Set<Player> damagers, int lockoutMinutes) {
        HashSet<Player> lockedOutPlayers = new HashSet<Player>();
        String bossIdentifier = DungeonBossLockoutHandler.getBossIdentifier(boss);
        for (Player player : damagers) {
            if (player.hasMetadata("NPC") || !PlayerData.isInMemory(player.getUniqueId())) continue;
            DungeonBossLockout lockout = PlayerData.getDungeonBossLockout(player.getUniqueId());
            if (lockout == null) {
                lockout = new DungeonBossLockout();
            }
            if (lockout.isLockedOut(bossIdentifier)) {
                lockedOutPlayers.add(player);
                DungeonBossLockoutHandler.notifyLockout(player, boss, lockout, bossIdentifier);
                continue;
            }
            lockout.addLockout(bossIdentifier, lockoutMinutes);
            PlayerData.updateDungeonBossLockout(player.getUniqueId(), lockout);
        }
        return lockedOutPlayers;
    }

    private static void notifyLockout(Player player, InstancedBossEntity boss, DungeonBossLockout lockout, String bossIdentifier) {
        String subtitle = ChatColorConverter.convert(DungeonsConfig.getDungeonLockoutSubtitle());
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(subtitle));
        player.sendTitle("", subtitle, 10, 70, 20);
        String bossName = boss.getName();
        String remainingTime = lockout.getFormattedRemainingTime(bossIdentifier);
        String chatMessage = ChatColorConverter.convert(DungeonsConfig.getDungeonLockoutChatMessage().replace("$bossName", bossName).replace("$remainingTime", remainingTime));
        player.sendMessage(chatMessage);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInstancedBossDeath(EliteMobDeathEvent event) {
        EliteEntity eliteEntity = event.getEliteEntity();
        if (!(eliteEntity instanceof InstancedBossEntity)) {
            return;
        }
        InstancedBossEntity instancedBoss = (InstancedBossEntity)eliteEntity;
        DungeonInstance dungeonInstance = instancedBoss.getDungeonInstance();
        if (dungeonInstance == null) {
            return;
        }
        ContentPackagesConfigFields config = dungeonInstance.getContentPackagesConfigFields();
        if (config == null) {
            return;
        }
        int lockoutMinutes = config.getDungeonLockoutMinutes();
        if (lockoutMinutes <= 0) {
            return;
        }
        Set<Player> lockedOutPlayers = DungeonBossLockoutHandler.processLockouts(instancedBoss, instancedBoss.getDamagers().keySet(), lockoutMinutes);
        instancedBoss.setLockoutPlayers(lockedOutPlayers);
    }
}

