/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.translations;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.translations.TranslationCsvParser;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class TranslationsConfigFields {
    private static final String TRANSLATIONS_DATA_SUFFIX = "_data.csv";
    private final String languageName;
    private final String languageCode;
    private TranslationCsvParser.TranslationData translationData;
    private TranslationCsvParser.TranslationData translationDataSnapshot;
    private Path translationsPath;
    private Path translationsDataPath;
    private boolean saving = false;
    private boolean dirty = false;

    public TranslationsConfigFields() {
        String configLang = DefaultConfig.getLanguage();
        this.languageName = configLang.replace(".yml", "").replace(".csv", "").toLowerCase();
        this.languageCode = this.getLanguageCode(this.languageName);
        this.initialize();
    }

    private String getLanguageCode(String languageName) {
        return switch (languageName) {
            case "english" -> "en";
            case "custom" -> "custom";
            case "french" -> "fr";
            case "german" -> "de";
            case "spanish" -> "es";
            case "italian" -> "it";
            case "brazilianPortuguese" -> "pt";
            case "russian" -> "ru";
            case "chinese", "chinesesimplified" -> "zh_cn";
            case "chinesetraditional" -> "zh_tw";
            case "japanese" -> "ja";
            case "korean" -> "ko";
            case "polish" -> "pl";
            case "dutch" -> "nl";
            case "czech" -> "cs";
            case "hungarian" -> "hu";
            case "romanian" -> "ro";
            case "turkish" -> "tr";
            case "vietnamese" -> "vi";
            case "indonesian" -> "id";
            default -> languageName;
        };
    }

    private void initialize() {
        Path folder = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), "translations");
        String csvFilename = this.languageName + ".csv";
        this.translationsPath = folder.resolve(csvFilename);
        this.translationsDataPath = folder.resolve(this.languageName + TRANSLATIONS_DATA_SUFFIX);
        try {
            Files.createDirectories(folder, new FileAttribute[0]);
            if (Files.exists(this.translationsPath, new LinkOption[0])) {
                this.translationData = TranslationCsvParser.parse(this.translationsPath);
                Logger.info("Loaded translations from " + csvFilename);
            } else {
                try (InputStream in = MetadataHandler.PLUGIN.getResource("translations/" + csvFilename);){
                    if (in != null) {
                        Files.copy(in, this.translationsPath, new CopyOption[0]);
                        this.translationData = TranslationCsvParser.parse(this.translationsPath);
                        Logger.info("Copied bundled translation: " + csvFilename);
                    } else {
                        this.translationData = new TranslationCsvParser.TranslationData(List.of("en", this.languageCode));
                        Logger.info("Created new empty translations for: " + this.languageName);
                    }
                }
            }
            this.translationData.addLanguage("en");
            this.translationData.addLanguage(this.languageCode);
            this.translationDataSnapshot = Files.exists(this.translationsDataPath, new LinkOption[0]) ? TranslationCsvParser.parse(this.translationsDataPath) : new TranslationCsvParser.TranslationData(List.of("en", this.languageCode));
            this.processConfigFields();
        }
        catch (IOException e) {
            Logger.warn("Failed to initialize translations: " + e.getMessage());
            this.translationData = new TranslationCsvParser.TranslationData(List.of("en", this.languageCode));
            this.translationDataSnapshot = new TranslationCsvParser.TranslationData(List.of("en", this.languageCode));
        }
    }

    private void processConfigFields() {
        String csvFilename = this.languageName + ".csv";
        try (InputStream in = MetadataHandler.PLUGIN.getResource("translations/" + csvFilename);){
            if (in == null) {
                return;
            }
            Path tempPath = Files.createTempFile("elitemobs_trans_", ".csv", new FileAttribute[0]);
            Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
            TranslationCsvParser.TranslationData bundledData = TranslationCsvParser.parse(tempPath);
            Files.delete(tempPath);
            boolean updated = false;
            for (String key : bundledData.getKeys()) {
                Object bundledLangValue;
                Object bundledEnValue = bundledData.get(key, "en");
                if (bundledEnValue == null) continue;
                Object snapshotEnValue = this.translationDataSnapshot.get(key, "en");
                Object liveEnValue = this.translationData.get(key, "en");
                if (snapshotEnValue == null) {
                    if (liveEnValue == null) {
                        this.translationData.set(key, "en", bundledEnValue);
                        bundledLangValue = bundledData.get(key, this.languageCode);
                        if (bundledLangValue != null) {
                            this.translationData.set(key, this.languageCode, bundledLangValue);
                        }
                        updated = true;
                    }
                } else if (!bundledEnValue.equals(snapshotEnValue) && snapshotEnValue.equals(liveEnValue)) {
                    this.translationData.set(key, "en", bundledEnValue);
                    bundledLangValue = bundledData.get(key, this.languageCode);
                    if (bundledLangValue != null) {
                        this.translationData.set(key, this.languageCode, bundledLangValue);
                    }
                    Logger.info("Auto-updated translation: " + key);
                    updated = true;
                }
                this.translationDataSnapshot.set(key, "en", bundledEnValue);
                bundledLangValue = bundledData.get(key, this.languageCode);
                if (bundledLangValue == null) continue;
                this.translationDataSnapshot.set(key, this.languageCode, bundledLangValue);
            }
            if (updated) {
                this.save();
                this.saveSnapshot();
            }
        }
        catch (IOException e) {
            Logger.warn("Failed to process bundled translations: " + e.getMessage());
        }
    }

    public void add(String filename, String key, Object value) {
        if (value == null) {
            return;
        }
        String filteredFilename = filename.replace(".yml", "");
        String realKey = filteredFilename + "." + key;
        if (value instanceof String) {
            String s = (String)((Object)value);
            String fixed = this.fixConfigColors(s);
            if (fixed.isEmpty()) {
                return;
            }
            value = fixed;
        } else if (value instanceof List) {
            List list = value;
            List<String> fixedList = this.fixConfigColors(list);
            if (fixedList.isEmpty()) {
                return;
            }
            value = fixedList;
        }
        if (this.translationData.get(realKey, "en") != null) {
            return;
        }
        this.translationData.set(realKey, "en", value);
        if (!this.languageCode.equals("en") && this.translationData.get(realKey, this.languageCode) == null) {
            this.translationData.set(realKey, this.languageCode, value);
        }
        this.dirty = true;
        this.scheduleSave();
    }

    public Object get(String filename, String key) {
        String filteredFilename = filename.replace(".yml", "");
        String realKey = filteredFilename + "." + key;
        Object value = null;
        if (!this.languageCode.equals("en")) {
            value = this.translationData.get(realKey, this.languageCode);
        }
        if (value == null) {
            value = this.translationData.get(realKey, "en");
        }
        if (value instanceof String) {
            String s = (String)value;
            return ChatColorConverter.convert(s);
        }
        if (value instanceof List) {
            List list;
            List stringList = list = (List)value;
            return ChatColorConverter.convert(stringList);
        }
        return value;
    }

    private void scheduleSave() {
        if (this.saving) {
            return;
        }
        this.saving = true;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MetadataHandler.PLUGIN, () -> {
            if (this.dirty) {
                this.save();
                this.dirty = false;
            }
            this.saving = false;
        }, 100L);
    }

    private void save() {
        try {
            TranslationCsvParser.write(this.translationData, this.translationsPath);
        }
        catch (IOException e) {
            Logger.warn("Failed to save translations: " + e.getMessage());
        }
    }

    private void saveSnapshot() {
        try {
            TranslationCsvParser.write(this.translationDataSnapshot, this.translationsDataPath);
        }
        catch (IOException e) {
            Logger.warn("Failed to save translation snapshot: " + e.getMessage());
        }
    }

    private String fixConfigColors(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("\u00a7", "&");
    }

    private List<String> fixConfigColors(List<String> values) {
        return values.stream().map(this::fixConfigColors).toList();
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void shutdown() {
        if (this.dirty) {
            this.save();
            this.dirty = false;
        }
    }
}

