/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.translations;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TranslationCsvParser {
    private static final Pattern LIST_INDEX_PATTERN = Pattern.compile("^(.+)\\[(\\d+)]$");

    public static TranslationData parse(File file) throws IOException {
        return TranslationCsvParser.parse(file.toPath());
    }

    public static TranslationData parse(Path path) throws IOException {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String line;
            StringBuilder currentRow = new StringBuilder();
            boolean inQuotes = false;
            boolean firstLine = true;
            while ((line = reader.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                    if (line.length() > 0 && line.charAt(0) == '\ufeff') {
                        line = line.substring(1);
                    }
                }
                if (currentRow.length() == 0 && line.trim().isEmpty() || currentRow.length() == 0 && line.trim().startsWith("#")) continue;
                currentRow.append(line);
                for (char c : line.toCharArray()) {
                    if (c != '\"') continue;
                    inQuotes = !inQuotes;
                }
                if (!inQuotes) {
                    String[] fields = TranslationCsvParser.parseCSVRow(currentRow.toString());
                    if (fields.length > 0) {
                        rows.add(fields);
                    }
                    currentRow = new StringBuilder();
                    continue;
                }
                currentRow.append("\n");
            }
        }
        if (rows.isEmpty()) {
            throw new IOException("CSV file is empty or has no valid rows");
        }
        String[] header = (String[])rows.get(0);
        if (header.length < 2) {
            throw new IOException("CSV header must have at least 'key' and one language column");
        }
        ArrayList<String> languages = new ArrayList<String>();
        for (int i = 1; i < header.length; ++i) {
            languages.add(header[i].trim().toLowerCase());
        }
        TranslationData data = new TranslationData(languages);
        LinkedHashMap<String, Map> indexedEntries = new LinkedHashMap<String, Map>();
        for (int rowIndex = 1; rowIndex < rows.size(); ++rowIndex) {
            String[] row = (String[])rows.get(rowIndex);
            if (row.length == 0 || row[0].trim().isEmpty()) continue;
            String rawKey = row[0].trim();
            Matcher matcher = LIST_INDEX_PATTERN.matcher(rawKey);
            if (matcher.matches()) {
                String baseKey = matcher.group(1);
                int index = Integer.parseInt(matcher.group(2));
                for (int langIdx = 0; langIdx < languages.size() && langIdx + 1 < row.length; ++langIdx) {
                    String language = (String)languages.get(langIdx);
                    String value = row[langIdx + 1];
                    indexedEntries.computeIfAbsent(baseKey, k -> new LinkedHashMap()).computeIfAbsent(language, k -> new TreeMap()).put(index, value);
                }
                continue;
            }
            for (int langIdx = 0; langIdx < languages.size() && langIdx + 1 < row.length; ++langIdx) {
                String language = (String)languages.get(langIdx);
                String value = row[langIdx + 1];
                data.set(rawKey, language, value);
            }
        }
        for (Map.Entry keyEntry : indexedEntries.entrySet()) {
            String baseKey = (String)keyEntry.getKey();
            for (Map.Entry langEntry : ((Map)keyEntry.getValue()).entrySet()) {
                String language = (String)langEntry.getKey();
                TreeMap indexMap = (TreeMap)langEntry.getValue();
                ArrayList<String> list = new ArrayList<String>();
                int expectedIndex = 0;
                for (Map.Entry indexEntry : indexMap.entrySet()) {
                    int index = (Integer)indexEntry.getKey();
                    while (list.size() < index) {
                        list.add("");
                    }
                    list.add((String)indexEntry.getValue());
                    expectedIndex = index + 1;
                }
                data.set(baseKey, language, list);
            }
        }
        return data;
    }

    private static String[] parseCSVRow(String row) {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        boolean hadQuotes = false;
        for (int i = 0; i < row.length(); ++i) {
            char c = row.charAt(i);
            if (inQuotes) {
                if (c == '\"') {
                    if (i + 1 < row.length() && row.charAt(i + 1) == '\"') {
                        current.append('\"');
                        ++i;
                        continue;
                    }
                    inQuotes = false;
                    continue;
                }
                current.append(c);
                continue;
            }
            if (c == '\"') {
                inQuotes = true;
                hadQuotes = true;
                continue;
            }
            if (c == ',') {
                fields.add(current.toString());
                current = new StringBuilder();
                hadQuotes = false;
                continue;
            }
            current.append(c);
        }
        fields.add(current.toString());
        return fields.toArray(new String[0]);
    }

    public static void write(TranslationData data, File file) throws IOException {
        TranslationCsvParser.write(data, file.toPath());
    }

    /*
     * Could not resolve type clashes
     */
    public static void write(TranslationData data, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(65279);
            List<String> languages = data.getLanguages();
            writer.write(TranslationCsvParser.escapeCSV("key"));
            for (String lang : languages) {
                writer.write(",");
                writer.write(TranslationCsvParser.escapeCSV(lang));
            }
            writer.newLine();
            ArrayList<String> sortedKeys = new ArrayList<String>(data.getKeys());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                Object lang4;
                Object firstValue = null;
                Iterator<String> iterator = languages.iterator();
                while (iterator.hasNext() && (firstValue = data.get(key, (String)(lang4 = iterator.next()))) == null) {
                }
                if (firstValue instanceof List) {
                    int maxSize = 0;
                    lang4 = languages.iterator();
                    while (lang4.hasNext()) {
                        String lang2 = (String)lang4.next();
                        List<String> list = data.getList(key, lang2);
                        if (list == null) continue;
                        maxSize = Math.max(maxSize, list.size());
                    }
                    for (int i = 0; i < maxSize; ++i) {
                        writer.write(TranslationCsvParser.escapeCSV(key + "[" + i + "]"));
                        for (String lang3 : languages) {
                            writer.write(",");
                            List<String> list = data.getList(key, lang3);
                            if (list != null && i < list.size()) {
                                writer.write(TranslationCsvParser.escapeCSV(list.get(i)));
                                continue;
                            }
                            writer.write("\"\"");
                        }
                        writer.newLine();
                    }
                    continue;
                }
                writer.write(TranslationCsvParser.escapeCSV(key));
                for (Object lang4 : languages) {
                    writer.write(",");
                    String value = data.getString(key, (String)lang4);
                    writer.write(TranslationCsvParser.escapeCSV(value != null ? value : ""));
                }
                writer.newLine();
            }
        }
    }

    private static String escapeCSV(String value) {
        if (value == null) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (char c : value.toCharArray()) {
            if (c == '\"') {
                sb.append("\"\"");
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void mergeNewKeys(TranslationData existing, TranslationData additions) {
        for (String key : additions.getKeys()) {
            if (existing.hasKey(key)) continue;
            for (String lang : additions.getLanguages()) {
                Object value = additions.get(key, lang);
                if (value == null) continue;
                existing.addLanguage(lang);
                existing.set(key, lang, value);
            }
        }
    }

    public static class TranslationData {
        private final List<String> languages;
        private final Map<String, Map<String, Object>> translations;

        public TranslationData(List<String> languages) {
            this.languages = new ArrayList<String>(languages);
            this.translations = new LinkedHashMap<String, Map<String, Object>>();
        }

        public List<String> getLanguages() {
            return Collections.unmodifiableList(this.languages);
        }

        public Object get(String key, String language) {
            Map<String, Object> langMap = this.translations.get(key);
            if (langMap == null) {
                return null;
            }
            return langMap.get(language);
        }

        public String getString(String key, String language) {
            Object value = this.get(key, language);
            if (value instanceof String) {
                return (String)value;
            }
            return null;
        }

        public List<String> getList(String key, String language) {
            Object value = this.get(key, language);
            if (value instanceof List) {
                return (List)value;
            }
            return null;
        }

        public void set(String key, String language, Object value) {
            this.translations.computeIfAbsent(key, k -> new LinkedHashMap()).put(language, value);
        }

        public boolean hasKey(String key) {
            return this.translations.containsKey(key);
        }

        public Set<String> getKeys() {
            return Collections.unmodifiableSet(this.translations.keySet());
        }

        public void addLanguage(String language) {
            if (!this.languages.contains(language)) {
                this.languages.add(language);
            }
        }
    }
}

