/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config;

import com.magmaguy.elitemobs.config.ConfigurationEngine;
import com.magmaguy.magmacore.config.ConfigurationFile;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class EconomySettingsConfig
extends ConfigurationFile {
    private static boolean enableEconomy;
    private static double resaleValue;
    private static String currencyName;
    private static boolean useVault;
    private static boolean enableCurrencyShower;
    private static double currencyShowerMultiplier;
    private static String chatCurrencyShowerMessage;
    private static String actionBarCurrencyShowerMessage;
    private static String lootShowerMaterial1;
    private static String lootShowerMaterial5;
    private static String lootShowerMaterial10;
    private static String lootShowerMaterial20;
    private static String lootShowerMaterial50;
    private static String lootShowerMaterial100;
    private static String lootShowerMaterial500;
    private static String lootShowerMaterial1000;
    private static String adventurersGuildNotificationMessage;
    private static double defaultMaterialWorth;
    private static FileConfiguration thisConfiguration;
    private static double playerToPlayerTaxes;
    private static String economyPayMessage;
    private static String economyCurrencyLeftMessage;
    private static String economyPaymentReceivedMessage;
    private static String economyPaymentInsufficientCurrency;
    private static String economyWalletCommand;
    private static String economyTaxMessage;
    private static String shopBuyMessage;
    private static String shopSellMessage;
    private static String shopInsufficientFundsMessage;
    private static String shopSaleInstructions;
    private static String shopSaleOthersItems;
    private static String shopCurrentBalance;
    private static String shopItemPrice;
    private static String shopBatchSellMessage;

    public EconomySettingsConfig() {
        super("EconomySettings.yml");
    }

    private static void addMaterial(FileConfiguration fileConfiguration, Material material, double value) {
        ConfigurationEngine.setDouble(List.of("Sets the worth of this material for the elitemobs currency system."), fileConfiguration, "materialWorth." + material.name(), value);
    }

    public static double getMaterialWorth(Material material) {
        try {
            return thisConfiguration.getDouble("materialWorth." + material.name());
        }
        catch (Exception ex) {
            return defaultMaterialWorth;
        }
    }

    @Override
    public void initializeValues() {
        thisConfiguration = this.fileConfiguration;
        double netheriteLevel = 18.0;
        double tridentLevel = 17.0;
        double diamondLevel = 17.0;
        double ironLevel = 16.0;
        double stoneChainLevel = 15.0;
        double goldWoodLeatherLevel = 13.0;
        enableEconomy = ConfigurationEngine.setBoolean(List.of("Sets if the EliteMobs economy is enabled. This means elite coins, the ability to buy and sell gear and the ability to upgrade guild ranks", "If disabled, players will not be able to progress in the plugin!"), this.fileConfiguration, "enableEconomy", true);
        resaleValue = ConfigurationEngine.setDouble(List.of("Sets the resale item of items, as a % of the original price. 5 is 5%"), this.fileConfiguration, "itemResaleValue", 5.0);
        currencyName = ConfigurationEngine.setString(List.of("Sets the in-game name of the currency used."), this.file, this.fileConfiguration, "currencyName", "Elite Coins", true);
        useVault = ConfigurationEngine.setBoolean(List.of("Sets the plugin to use Vault. THIS IS NOT RECOMMENDED! Read why here: https://github.com/MagmaGuy/EliteMobs/wiki/%5BThird-party-support%5D-Vault"), this.fileConfiguration, "useVault - not recommended", false);
        enableCurrencyShower = ConfigurationEngine.setBoolean(List.of("Sets if elites will drop coins based on their level."), this.fileConfiguration, "enableCurrencyShower", true);
        currencyShowerMultiplier = ConfigurationEngine.setDouble(List.of("Sets the multiplier for the currency dropped by elites."), this.fileConfiguration, "currencyShowerTierMultiplier", 1.0);
        chatCurrencyShowerMessage = ConfigurationEngine.setString(List.of("Sets the message sent when players pick up elite currency."), this.file, this.fileConfiguration, "chatCurrencyShowerMessage", "&7[EM] You've picked up &a$amount $currency_name!", true);
        actionBarCurrencyShowerMessage = ConfigurationEngine.setString(List.of("Sets the action bar message sent when players pick up elite currency."), this.file, this.fileConfiguration, "actionbarCurrencyShowerMessage", "&7[EM] You've picked up &a$amount $currency_name!", true);
        lootShowerMaterial1 = ConfigurationEngine.setString(List.of("Sets the material type of 1 dropped elite coin."), this.file, this.fileConfiguration, "lootShowerMaterial.1", Material.GOLD_NUGGET.name(), false);
        ConfigurationEngine.setInt(List.of("Sets the custom model ID for 1 dropped elite coin. Used by the resource pack."), this.fileConfiguration, "lootShowerData.1", 1);
        ConfigurationEngine.setString(this.fileConfiguration, "lootShowerDataV2.1", "elitemobs:coins/coin1");
        lootShowerMaterial5 = ConfigurationEngine.setString(this.file, this.fileConfiguration, "lootShowerMaterial.5", Material.GOLD_INGOT.name(), false);
        ConfigurationEngine.setString(this.fileConfiguration, "lootShowerDataV2.5", "elitemobs:coins/coin1");
        lootShowerMaterial10 = ConfigurationEngine.setString(this.file, this.fileConfiguration, "lootShowerMaterial.10", Material.GOLD_BLOCK.name(), false);
        ConfigurationEngine.setString(this.fileConfiguration, "lootShowerDataV2.10", "elitemobs:coins/coin2");
        lootShowerMaterial20 = ConfigurationEngine.setString(this.file, this.fileConfiguration, "lootShowerMaterial.20", Material.EMERALD.name(), false);
        ConfigurationEngine.setString(this.fileConfiguration, "lootShowerDataV2.20", "elitemobs:coins/coin3");
        lootShowerMaterial50 = ConfigurationEngine.setString(this.file, this.fileConfiguration, "lootShowerMaterial.50", Material.EMERALD_BLOCK.name(), false);
        ConfigurationEngine.setString(this.fileConfiguration, "lootShowerDataV2.50", "elitemobs:coins/coin4");
        lootShowerMaterial100 = ConfigurationEngine.setString(this.file, this.fileConfiguration, "lootShowerMaterial.100", Material.DIAMOND.name(), false);
        ConfigurationEngine.setString(this.fileConfiguration, "lootShowerDataV2.100", "elitemobs:coins/coin4");
        lootShowerMaterial500 = ConfigurationEngine.setString(this.file, this.fileConfiguration, "lootShowerMaterial.500", Material.DIAMOND_BLOCK.name(), false);
        ConfigurationEngine.setString(this.fileConfiguration, "lootShowerDataV2.500", "elitemobs:coins/coin4");
        lootShowerMaterial1000 = ConfigurationEngine.setString(this.file, this.fileConfiguration, "lootShowerMaterial.1000", Material.NETHER_STAR.name(), false);
        ConfigurationEngine.setString(this.fileConfiguration, "lootShowerDataV2.1000", "elitemobs:coins/coin4");
        adventurersGuildNotificationMessage = ConfigurationEngine.setString(List.of("Send the message players get after looting currency. Useful for tutorial purposes."), this.file, this.fileConfiguration, "adventurersGuildNotificationMessages", "&7[EM] Extra spending money? Try &a/ag !", true);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_AXE, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_BOOTS, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_CHESTPLATE, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_LEGGINGS, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_HELMET, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_PICKAXE, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_SHOVEL, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_SWORD, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.DIAMOND_HOE, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_AXE, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_BOOTS, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_LEGGINGS, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_CHESTPLATE, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_HELMET, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_PICKAXE, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_SHOVEL, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_HOE, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.IRON_SWORD, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.SHIELD, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.BOW, ironLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.CHAINMAIL_BOOTS, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.CHAINMAIL_LEGGINGS, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.CHAINMAIL_CHESTPLATE, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.CHAINMAIL_HELMET, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.STONE_SWORD, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.STONE_AXE, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.STONE_PICKAXE, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.STONE_SHOVEL, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.STONE_HOE, stoneChainLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_AXE, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_BOOTS, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_LEGGINGS, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_CHESTPLATE, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_HELMET, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_SWORD, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_SHOVEL, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_PICKAXE, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_HOE, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.GOLDEN_APPLE, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.ENCHANTED_GOLDEN_APPLE, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.LEATHER_BOOTS, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.LEATHER_LEGGINGS, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.LEATHER_CHESTPLATE, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.LEATHER_HELMET, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.WOODEN_SWORD, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.WOODEN_AXE, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.WOODEN_HOE, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.WOODEN_PICKAXE, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.TRIDENT, tridentLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.ELYTRA, diamondLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.TURTLE_HELMET, goldWoodLeatherLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_AXE, netheriteLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_PICKAXE, netheriteLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_SHOVEL, netheriteLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_HOE, netheriteLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_SWORD, netheriteLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_HELMET, netheriteLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_CHESTPLATE, netheriteLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_LEGGINGS, netheriteLevel);
        EconomySettingsConfig.addMaterial(this.fileConfiguration, Material.NETHERITE_BOOTS, netheriteLevel);
        defaultMaterialWorth = ConfigurationEngine.setDouble(List.of("Sets the default material worth for items not specifically defined."), this.fileConfiguration, "materialWorth.defaultMaterialWorth", 1.0);
        playerToPlayerTaxes = ConfigurationEngine.setDouble(List.of("Sets the tax rate for transactions between players.", "Strongly recommended for balance reasons, as high level players can gain up to 6x more currency and try to use other players to bypass prestige currency resets."), this.fileConfiguration, "playerToPlayerPaymentTaxes", 0.2);
        economyPayMessage = ConfigurationEngine.setString(List.of("Message sent when sending elite currency to other players."), this.file, this.fileConfiguration, "Economy pay message v2", "&2You have paid &2$amount_sent $currency_name &2to $receiver&2, who got $amount_received after taxes!", true);
        economyCurrencyLeftMessage = ConfigurationEngine.setString(List.of("Message sent after players send currency."), this.file, this.fileConfiguration, "Economy currency left message", "You now have &2$amount_left $currency_name", true);
        economyPaymentReceivedMessage = ConfigurationEngine.setString(List.of("Message received when receiving currency."), this.file, this.fileConfiguration, "Economy money from payment message", "You have received &2$amount_received $currency_name &ffrom $sender", true);
        economyPaymentInsufficientCurrency = ConfigurationEngine.setString(List.of("Message sent when players try to send an amount of coins they do not have."), this.file, this.fileConfiguration, "Economy payment insufficient currency", "&cYou don't have enough $currency_name to do that!", true);
        economyWalletCommand = ConfigurationEngine.setString(List.of("/em balance message"), this.file, this.fileConfiguration, "Wallet command message", "You have &2$balance $currency_name", true);
        economyTaxMessage = ConfigurationEngine.setString(List.of("Confirmation message sent when players try to send currency to another player."), this.file, this.fileConfiguration, "Tax confirmation message", "&cSending a payment will cost $percentage% in taxes. &aDo &9$command &ato proceed!", true);
        shopBuyMessage = ConfigurationEngine.setString(List.of("Message sent when a player buys from a shop."), this.file, this.fileConfiguration, "Shop buy message", "&aYou have bought $item_name &afor $item_value $currency_name!", true);
        shopCurrentBalance = ConfigurationEngine.setString(List.of("Message sent when a player interacts with a shop."), this.file, this.fileConfiguration, "Shop current balance message", "&aYou have $currency_amount $currency_name.", true);
        shopInsufficientFundsMessage = ConfigurationEngine.setString(List.of("Message sent when players don't have enough currency to purchase an item"), this.file, this.fileConfiguration, "Shop insufficient funds message", "&cYou don't have enough $currency_name!", true);
        shopItemPrice = ConfigurationEngine.setString(List.of("Second part of message sent when players try to purchase an item they can not afford."), this.file, this.fileConfiguration, "Shop item cost message", "That item costs &c$item_value $currency_name.", true);
        shopSellMessage = ConfigurationEngine.setString(List.of("Message sent upon selling an item to a shop."), this.file, this.fileConfiguration, "Shop sell message", "&aYou have sold $item_name &afor $currency_amount $currency_name!", true);
        shopSaleOthersItems = ConfigurationEngine.setString(List.of("Message sent upon trying to sell an item that does not belong to that player."), this.file, this.fileConfiguration, "Shop sale player items warning", "&cYou can't sell items that are not currently soulbound to you! This includes items from other prestige tiers!", true);
        shopSaleInstructions = ConfigurationEngine.setString(List.of("Message sent upon trying to sell a non-EliteMobs item"), this.file, this.fileConfiguration, "Shop sale instructions", "&cYou can only sell EliteMobs loot here! (Armor / weapons dropped from elites showing a value on their lore)", true);
        shopBatchSellMessage = ConfigurationEngine.setString(List.of("Message sent upon selling a batch of elite items."), this.file, this.fileConfiguration, "shopBatchSellItem", "&aYou have sold your items &afor $currency_amount $currency_name!", true);
    }

    @Generated
    public static boolean isEnableEconomy() {
        return enableEconomy;
    }

    @Generated
    public static double getResaleValue() {
        return resaleValue;
    }

    @Generated
    public static String getCurrencyName() {
        return currencyName;
    }

    @Generated
    public static boolean isUseVault() {
        return useVault;
    }

    @Generated
    public static boolean isEnableCurrencyShower() {
        return enableCurrencyShower;
    }

    @Generated
    public static double getCurrencyShowerMultiplier() {
        return currencyShowerMultiplier;
    }

    @Generated
    public static String getChatCurrencyShowerMessage() {
        return chatCurrencyShowerMessage;
    }

    @Generated
    public static String getActionBarCurrencyShowerMessage() {
        return actionBarCurrencyShowerMessage;
    }

    @Generated
    public static String getLootShowerMaterial1() {
        return lootShowerMaterial1;
    }

    @Generated
    public static String getLootShowerMaterial5() {
        return lootShowerMaterial5;
    }

    @Generated
    public static String getLootShowerMaterial10() {
        return lootShowerMaterial10;
    }

    @Generated
    public static String getLootShowerMaterial20() {
        return lootShowerMaterial20;
    }

    @Generated
    public static String getLootShowerMaterial50() {
        return lootShowerMaterial50;
    }

    @Generated
    public static String getLootShowerMaterial100() {
        return lootShowerMaterial100;
    }

    @Generated
    public static String getLootShowerMaterial500() {
        return lootShowerMaterial500;
    }

    @Generated
    public static String getLootShowerMaterial1000() {
        return lootShowerMaterial1000;
    }

    @Generated
    public static String getAdventurersGuildNotificationMessage() {
        return adventurersGuildNotificationMessage;
    }

    @Generated
    public static double getDefaultMaterialWorth() {
        return defaultMaterialWorth;
    }

    @Generated
    public static FileConfiguration getThisConfiguration() {
        return thisConfiguration;
    }

    @Generated
    public static double getPlayerToPlayerTaxes() {
        return playerToPlayerTaxes;
    }

    @Generated
    public static String getEconomyPayMessage() {
        return economyPayMessage;
    }

    @Generated
    public static String getEconomyCurrencyLeftMessage() {
        return economyCurrencyLeftMessage;
    }

    @Generated
    public static String getEconomyPaymentReceivedMessage() {
        return economyPaymentReceivedMessage;
    }

    @Generated
    public static String getEconomyPaymentInsufficientCurrency() {
        return economyPaymentInsufficientCurrency;
    }

    @Generated
    public static String getEconomyWalletCommand() {
        return economyWalletCommand;
    }

    @Generated
    public static String getEconomyTaxMessage() {
        return economyTaxMessage;
    }

    @Generated
    public static String getShopBuyMessage() {
        return shopBuyMessage;
    }

    @Generated
    public static String getShopSellMessage() {
        return shopSellMessage;
    }

    @Generated
    public static String getShopInsufficientFundsMessage() {
        return shopInsufficientFundsMessage;
    }

    @Generated
    public static String getShopSaleInstructions() {
        return shopSaleInstructions;
    }

    @Generated
    public static String getShopSaleOthersItems() {
        return shopSaleOthersItems;
    }

    @Generated
    public static String getShopCurrentBalance() {
        return shopCurrentBalance;
    }

    @Generated
    public static String getShopItemPrice() {
        return shopItemPrice;
    }

    @Generated
    public static String getShopBatchSellMessage() {
        return shopBatchSellMessage;
    }
}

