/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.arguments.IntegerCommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.command.arguments.PlayerCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SkillSetCommand
extends AdvancedCommand {
    public SkillSetCommand() {
        super(List.of("skill"));
        this.addLiteral("set");
        this.addArgument("player", new PlayerCommandArgument());
        this.addArgument("skillType", new ListStringCommandArgument(Arrays.stream(SkillType.values()).map(Enum::name).toList(), "<skillType>"));
        this.addArgument("level", new IntegerCommandArgument("<level>"));
        this.setUsage("/em skill set <player> <skillType> <level>");
        this.setPermission("elitemobs.skill.admin");
        this.setDescription("Sets a player's skill level for a specific skill type.");
    }

    @Override
    public void execute(CommandData commandData) {
        SkillType skillType;
        String playerName = commandData.getStringArgument("player");
        String skillTypeName = commandData.getStringArgument("skillType");
        int level = commandData.getIntegerArgument("level");
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            Logger.sendMessage(commandData.getCommandSender(), "&cPlayer not found: " + playerName);
            return;
        }
        try {
            skillType = SkillType.valueOf(skillTypeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Logger.sendMessage(commandData.getCommandSender(), "&cInvalid skill type: " + skillTypeName);
            Logger.sendMessage(commandData.getCommandSender(), "&7Valid types: " + String.join((CharSequence)", ", Arrays.stream(SkillType.values()).map(Enum::name).toList()));
            return;
        }
        if (level < 1) {
            Logger.sendMessage(commandData.getCommandSender(), "&cLevel must be at least 1!");
            return;
        }
        if (level > 100) {
            Logger.sendMessage(commandData.getCommandSender(), "&eWarning: Level " + level + " is above the soft cap of 100.");
        }
        long targetXP = SkillXPCalculator.totalXPForLevel(level);
        PlayerData.setSkillXP(targetPlayer.getUniqueId(), skillType, targetXP);
        Logger.sendMessage(commandData.getCommandSender(), "&aSet " + targetPlayer.getName() + "'s " + skillType.getDisplayName() + " skill to level " + level + " (" + targetXP + " XP)");
    }
}

