/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.utils.VisualDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class DialogArmorStand {
    public static TextDisplay createDialogArmorStand(final Entity sourceEntity, String dialog, Vector offset) {
        offset.add(DialogArmorStand.getDisplacementVector(sourceEntity).subtract(new Vector(0, 1, 0)));
        final Vector finalOffset = offset;
        final TextDisplay armorStand = VisualDisplay.generateTemporaryTextDisplay(sourceEntity.getLocation().clone().add(finalOffset), dialog);
        new BukkitRunnable(){
            int taskTimer = 0;

            public void run() {
                ++this.taskTimer;
                if (this.taskTimer > 15 || !sourceEntity.isValid()) {
                    EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                    this.cancel();
                    return;
                }
                armorStand.teleport(sourceEntity.getLocation().clone().add(finalOffset).add(new Vector(0.0, (double)this.taskTimer * 0.05, 0.0)));
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 2L);
        return armorStand;
    }

    private static Vector getDisplacementVector(Entity sourceEntity) {
        double height = 2.3;
        if (sourceEntity instanceof LivingEntity) {
            height = ((LivingEntity)sourceEntity).getEyeHeight();
        }
        return new Vector(0.0, height, 0.0);
    }

    public static TextDisplay createDialogArmorStand(final LivingEntity sourceEntity, String dialog) {
        if (sourceEntity == null) {
            return null;
        }
        final TextDisplay armorStand = VisualDisplay.generateTemporaryTextDisplay(sourceEntity.getLocation().clone().add(DialogArmorStand.getDisplacementVector((Entity)sourceEntity)), dialog);
        new BukkitRunnable(){
            int taskTimer = 0;

            public void run() {
                if (this.taskTimer > 15 || !sourceEntity.isValid()) {
                    EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                    this.cancel();
                    return;
                }
                armorStand.teleport(sourceEntity.getLocation().clone().add(DialogArmorStand.getDisplacementVector((Entity)sourceEntity)));
                ++this.taskTimer;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        return armorStand;
    }
}

