/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.thirdparty.libsdisguises;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.magmacore.util.Logger;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class DisguiseEntity {
    public static void disguise(String disguiseName, Entity entity, String customDisguiseData, String filename) {
        DisguiseType disguiseType;
        if (disguiseName.contains("player:")) {
            DisguiseEntity.playerDisguise(disguiseName.replace("player:", ""), entity);
            return;
        }
        if (disguiseName.contains("custom")) {
            try {
                DisguiseEntity.customDisguise(disguiseName.replace("custom:", ""), entity, customDisguiseData, filename);
            }
            catch (Exception ex) {
                Logger.warn((String)("Failed to assign custom disguise " + disguiseName + "! Did you configure the disguise correctly?"));
            }
            return;
        }
        boolean baby = false;
        if (disguiseName.contains(":baby")) {
            disguiseName = disguiseName.replace(":baby", "");
            baby = true;
        }
        try {
            disguiseType = DisguiseType.valueOf((String)disguiseName);
        }
        catch (Exception ex) {
            Logger.warn((String)("Disguise " + disguiseName + " is not a valid disguise name! Entity " + entity.getCustomName() + " will not have a disguise."));
            return;
        }
        if (disguiseType.isMob()) {
            DisguiseEntity.livingEntityDisguise(disguiseType, entity, baby);
        } else if (disguiseType.isMisc()) {
            DisguiseEntity.miscEntityDisguise(disguiseType, entity);
        } else {
            Logger.warn((String)("Disguise " + disguiseName + " is not a valid disguise name! Entity " + entity.getCustomName() + " will not have a disguise."));
        }
    }

    private static void playerDisguise(String playerName, Entity entity) {
        PlayerDisguise playerDisguise = new PlayerDisguise(playerName);
        DisguiseEntity.scheduleDisguise((Disguise)playerDisguise, entity);
    }

    private static void livingEntityDisguise(DisguiseType disguiseType, Entity entity, boolean baby) {
        MobDisguise mobDisguise = new MobDisguise(disguiseType, !baby);
        DisguiseEntity.scheduleDisguise((Disguise)mobDisguise, entity);
    }

    private static void miscEntityDisguise(DisguiseType disguiseType, Entity entity) {
        MiscDisguise miscDisguise = new MiscDisguise(disguiseType);
        DisguiseEntity.scheduleDisguise((Disguise)miscDisguise, entity);
    }

    private static void customDisguise(String customDisguise, Entity entity, String customDisguiseData, String filename) {
        Disguise disguise = DisguiseAPI.getCustomDisguise((String)customDisguise);
        try {
            if (disguise == null && customDisguiseData != null) {
                DisguiseAPI.addCustomDisguise((String)customDisguise, (String)customDisguiseData);
                disguise = DisguiseAPI.getCustomDisguise((String)customDisguise);
            }
            if (disguise == null) {
                throw new NullPointerException();
            }
            DisguiseEntity.scheduleDisguise(disguise, entity);
        }
        catch (Exception ex) {
            Logger.warn((String)("Failed to set custom disguise for " + filename + " !"));
            Logger.warn((String)"Does the disguise exist? Is LibsDisguises up-to-date?");
        }
    }

    private static void scheduleDisguise(Disguise disguise, Entity entity) {
        DisguiseEntity.applyDisguise(disguise, entity);
        Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> DisguiseEntity.applyDisguise(disguise, entity), 20L);
    }

    private static void applyDisguise(Disguise disguise, Entity entity) {
        disguise.setEntity(entity);
        disguise.setDisguiseName(entity.getCustomName());
        disguise.setDynamicName(true);
        if ((DefaultConfig.isAlwaysShowNametags() || entity.getType().equals((Object)EntityType.VILLAGER)) && disguise instanceof PlayerDisguise) {
            ((PlayerDisguise)disguise).setNameVisible(true);
        } else if (disguise instanceof PlayerDisguise) {
            ((PlayerDisguise)disguise).setNameVisible(false);
        }
        disguise.startDisguise();
    }

    public static void setDisguiseNameVisibility(boolean disguiseNameVisibility, Entity entity, String name) {
        if (!Bukkit.getPluginManager().isPluginEnabled("LibsDisguises")) {
            return;
        }
        Disguise disguise = DisguiseAPI.getDisguise((Entity)entity);
        if (disguise == null) {
            return;
        }
        if (disguise instanceof PlayerDisguise) {
            ((PlayerDisguise)disguise).setNameVisible(true);
        }
    }
}

