/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.testing;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.elitemobs.skills.bonuses.PlayerSkillSelection;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ToggleSkill;
import com.magmaguy.elitemobs.testing.CombatSimulator;
import com.magmaguy.elitemobs.testing.CombatTestLog;
import com.magmaguy.elitemobs.testing.SkillTestResult;
import com.magmaguy.elitemobs.testing.TestReport;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SkillSystemTest {
    private static final Map<UUID, SkillSystemTest> activeSessions = new HashMap<UUID, SkillSystemTest>();
    private static final int[] TEST_LEVELS = new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100};
    private static final int HITS_PER_LEVEL = 200;
    private final Player player;
    private final UUID playerUUID;
    private final CombatSimulator combatSimulator;
    private final CombatTestLog testLog;
    private final TestReport report;
    private boolean cancelled = false;
    private BukkitTask currentTask;
    private BossBar progressBar;
    private final Map<SkillType, Long> savedSkillXP = new HashMap<SkillType, Long>();
    private final Map<SkillType, List<String>> savedSkillSelections = new HashMap<SkillType, List<String>>();
    private double savedAttackSpeed;
    private double savedKnockbackResistance;
    private final Map<SkillType, List<SkillBonus>> skillsByType = new EnumMap<SkillType, List<SkillBonus>>(SkillType.class);
    private final Queue<SkillType> typeQueue = new LinkedList<SkillType>();
    private SkillType currentType = null;
    private int currentLevelIndex = 0;
    private final Map<String, Map<Integer, Boolean>> results = new HashMap<String, Map<Integer, Boolean>>();
    private final Map<String, List<String>> issues = new HashMap<String, List<String>>();

    public SkillSystemTest(Player player) {
        this.player = player;
        this.playerUUID = player.getUniqueId();
        this.combatSimulator = new CombatSimulator(player);
        this.testLog = new CombatTestLog();
        this.report = new TestReport(this.playerUUID);
        activeSessions.put(this.playerUUID, this);
    }

    public static SkillSystemTest getSession(UUID playerUUID) {
        return activeSessions.get(playerUUID);
    }

    public static boolean hasActiveSession(UUID playerUUID) {
        return activeSessions.containsKey(playerUUID);
    }

    public void start() {
        for (SkillType type : SkillType.values()) {
            List<SkillBonus> skills = SkillBonusRegistry.getEnabledBonuses(type);
            if (skills.isEmpty()) continue;
            this.skillsByType.put(type, skills);
            this.typeQueue.add(type);
        }
        if (this.typeQueue.isEmpty()) {
            this.log("\u00a7c[Test] No skills found to test!");
            return;
        }
        int totalSkills = this.skillsByType.values().stream().mapToInt(List::size).sum();
        this.log("\u00a7a\u00a7l=== BATCH SKILL TEST STARTING ===");
        this.log("\u00a77Testing \u00a7e" + totalSkills + "\u00a77 skills across \u00a7e" + this.typeQueue.size() + "\u00a77 weapon types");
        this.log("\u00a77All skills of each type tested simultaneously!");
        this.testLog.logSection("BATCH SKILL SYSTEM TEST");
        this.testLog.log("Player: " + this.player.getName());
        this.testLog.log("Total skills: " + totalSkills);
        this.progressBar = Bukkit.createBossBar((String)"Initializing...", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
        this.progressBar.setProgress(0.0);
        this.progressBar.addPlayer(this.player);
        this.savePlayerState();
        this.setupPlayerForTesting();
        this.testNextType();
    }

    private void testNextType() {
        if (this.cancelled || this.typeQueue.isEmpty()) {
            this.completeTest();
            return;
        }
        this.currentType = this.typeQueue.poll();
        this.currentLevelIndex = 0;
        List<SkillBonus> skills = this.skillsByType.get((Object)this.currentType);
        this.log("");
        this.log("\u00a76=== Testing " + this.currentType.getDisplayName() + " \u00a77(" + skills.size() + " skills) ===");
        this.testLog.logSection(this.currentType.getDisplayName() + " (" + skills.size() + " skills)");
        SkillBonus firstSkill = skills.get(0);
        if (!this.combatSimulator.spawnSingleDummy(firstSkill)) {
            this.log("\u00a7cFailed to spawn dummy for " + this.currentType.getDisplayName());
            this.testNextType();
            return;
        }
        this.testNextLevel();
    }

    private void testNextLevel() {
        if (this.cancelled) {
            this.completeTest();
            return;
        }
        if (this.currentLevelIndex >= TEST_LEVELS.length) {
            this.summarizeTypeResults();
            this.combatSimulator.removeAllDummies();
            this.testNextType();
            return;
        }
        int testLevel = TEST_LEVELS[this.currentLevelIndex];
        List<SkillBonus> skills = this.skillsByType.get((Object)this.currentType);
        this.setPlayerSkillLevel(this.currentType, testLevel);
        this.activateAllSkills(this.currentType, skills);
        this.combatSimulator.equipWeapon(this.currentType);
        for (SkillBonus skill : skills) {
            skill.resetProcCount(this.player);
        }
        this.log("\u00a77Level \u00a7e" + testLevel + "\u00a77: Testing " + skills.size() + " skills...");
        this.testInstantLevel(testLevel, skills);
    }

    private void testInstantLevel(int testLevel, List<SkillBonus> skills) {
        String dummyId = skills.get(0).getSkillId();
        for (int i = 0; i < 200; ++i) {
            if (this.cancelled) {
                return;
            }
            if (!this.combatSimulator.hasDummy(dummyId)) {
                this.combatSimulator.respawnIfDead(dummyId, skills.get(0));
            }
            this.resetAllCooldowns(skills);
            this.performAttack(this.currentType, dummyId);
            this.combatSimulator.healDummy(dummyId);
        }
        this.updateProgressBar(this.currentType.getDisplayName() + " Lv." + testLevel, 200, 200, BarColor.GREEN);
        this.checkLevelResults(testLevel, skills);
        ++this.currentLevelIndex;
        new BukkitRunnable(){

            public void run() {
                SkillSystemTest.this.testNextLevel();
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
    }

    private void resetAllCooldowns(List<SkillBonus> skills) {
        for (SkillBonus skill : skills) {
            if (!(skill instanceof CooldownSkill)) continue;
            CooldownSkill cooldownSkill = (CooldownSkill)((Object)skill);
            cooldownSkill.endCooldown(this.player);
        }
    }

    private void checkLevelResults(int level, List<SkillBonus> skills) {
        StringBuilder sb = new StringBuilder();
        sb.append("  \u00a77Lv.").append(level).append(": ");
        int passed = 0;
        int failed = 0;
        for (SkillBonus skill : skills) {
            int procCount = skill.getProcCount(this.player);
            boolean shouldBeUnlocked = level >= skill.getRequiredLevel();
            boolean worked = procCount > 0;
            this.results.computeIfAbsent(skill.getSkillId(), k -> new HashMap()).put(level, worked == shouldBeUnlocked);
            if (shouldBeUnlocked) {
                if (worked) {
                    ++passed;
                    continue;
                }
                ++failed;
                this.issues.computeIfAbsent(skill.getSkillId(), k -> new ArrayList()).add("No procs at Lv." + level + " (should be unlocked)");
                continue;
            }
            if (!worked) {
                ++passed;
                continue;
            }
            ++failed;
            this.issues.computeIfAbsent(skill.getSkillId(), k -> new ArrayList()).add("Procced at Lv." + level + " (should be LOCKED, unlock=" + skill.getRequiredLevel() + ")");
        }
        if (failed == 0) {
            sb.append("\u00a7a\u2713 All ").append(passed).append(" passed");
        } else {
            sb.append("\u00a7a").append(passed).append(" passed, \u00a7c").append(failed).append(" failed");
        }
        this.log(sb.toString());
        this.testLog.log("Level " + level + ": " + passed + " passed, " + failed + " failed");
    }

    private void summarizeTypeResults() {
        List<SkillBonus> skills = this.skillsByType.get((Object)this.currentType);
        this.log("");
        this.log("\u00a77--- " + this.currentType.getDisplayName() + " Summary ---");
        for (SkillBonus skill : skills) {
            boolean allPassed;
            Map<Integer, Boolean> skillResults = this.results.get(skill.getSkillId());
            List<String> skillIssues = this.issues.get(skill.getSkillId());
            if (skillResults == null) continue;
            long passedLevels = skillResults.values().stream().filter(b -> b).count();
            boolean bl = allPassed = passedLevels == (long)TEST_LEVELS.length;
            if (allPassed) {
                this.log("  \u00a7a\u2713 " + skill.getBonusName() + " \u00a77(unlock Lv." + skill.getRequiredLevel() + ")");
            } else {
                this.log("  \u00a7c\u2717 " + skill.getBonusName() + " \u00a77(unlock Lv." + skill.getRequiredLevel() + ")");
                if (skillIssues != null) {
                    for (String issue : skillIssues) {
                        this.log("    \u00a7c- " + issue);
                    }
                }
            }
            SkillTestResult result = new SkillTestResult(skill.getSkillId(), skill.getBonusName(), skill.getSkillType(), skill.getRequiredLevel());
            result.setTotalHits(200 * TEST_LEVELS.length);
            if (skillIssues != null) {
                skillIssues.forEach(result::addIssue);
            }
            this.report.addResult(result);
        }
    }

    private void activateAllSkills(SkillType type, List<SkillBonus> skills) {
        for (String id : new ArrayList<String>(PlayerSkillSelection.getActiveSkills(this.playerUUID, type))) {
            PlayerSkillSelection.removeActiveSkill(this.playerUUID, type, id);
        }
        for (SkillBonus skill : skills) {
            PlayerSkillSelection.addActiveSkill(this.playerUUID, type, skill.getSkillId(), true);
            if (!(skill instanceof ToggleSkill)) continue;
            ToggleSkill toggleSkill = (ToggleSkill)((Object)skill);
            toggleSkill.enable(this.player);
        }
        SkillBonusRegistry.applyBonuses(this.player, type);
    }

    private double performAttack(SkillType skillType, String skillId) {
        return switch (skillType) {
            case SkillType.BOWS, SkillType.CROSSBOWS -> this.combatSimulator.simulateRangedAttack(skillId);
            case SkillType.TRIDENTS -> this.combatSimulator.simulateTridentAttack(skillId);
            case SkillType.ARMOR -> this.combatSimulator.simulateIncomingDamage(skillId, 10.0);
            default -> this.combatSimulator.simulateMeleeAttack(skillId);
        };
    }

    private void setPlayerSkillLevel(SkillType type, int level) {
        PlayerData.setSkillXP(this.playerUUID, type, SkillXPCalculator.totalXPForLevel(level));
    }

    private void savePlayerState() {
        AttributeInstance knockbackAttr;
        for (SkillType type : SkillType.values()) {
            this.savedSkillXP.put(type, PlayerData.getSkillXP(this.playerUUID, type));
            this.savedSkillSelections.put(type, new ArrayList<String>(PlayerSkillSelection.getActiveSkills(this.playerUUID, type)));
        }
        AttributeInstance attackSpeedAttr = this.player.getAttribute(Attribute.ATTACK_SPEED);
        if (attackSpeedAttr != null) {
            this.savedAttackSpeed = attackSpeedAttr.getBaseValue();
        }
        if ((knockbackAttr = this.player.getAttribute(Attribute.KNOCKBACK_RESISTANCE)) != null) {
            this.savedKnockbackResistance = knockbackAttr.getBaseValue();
        }
        this.combatSimulator.savePlayerArmor();
    }

    private void restorePlayerState() {
        AttributeInstance knockbackAttr;
        for (SkillType type : SkillType.values()) {
            Long xp = this.savedSkillXP.get((Object)type);
            if (xp != null) {
                PlayerData.setSkillXP(this.playerUUID, type, xp);
            }
            for (String id : new ArrayList<String>(PlayerSkillSelection.getActiveSkills(this.playerUUID, type))) {
                PlayerSkillSelection.removeActiveSkill(this.playerUUID, type, id);
            }
            List<String> saved = this.savedSkillSelections.get((Object)type);
            if (saved == null) continue;
            for (String id : saved) {
                PlayerSkillSelection.addActiveSkill(this.playerUUID, type, id);
            }
        }
        AttributeInstance attackSpeedAttr = this.player.getAttribute(Attribute.ATTACK_SPEED);
        if (attackSpeedAttr != null) {
            attackSpeedAttr.setBaseValue(this.savedAttackSpeed);
        }
        if ((knockbackAttr = this.player.getAttribute(Attribute.KNOCKBACK_RESISTANCE)) != null) {
            knockbackAttr.setBaseValue(this.savedKnockbackResistance);
        }
        this.combatSimulator.restorePlayerArmor();
    }

    private void setupPlayerForTesting() {
        AttributeInstance knockbackAttr;
        AttributeInstance attackSpeedAttr = this.player.getAttribute(Attribute.ATTACK_SPEED);
        if (attackSpeedAttr != null) {
            attackSpeedAttr.setBaseValue(100.0);
        }
        if ((knockbackAttr = this.player.getAttribute(Attribute.KNOCKBACK_RESISTANCE)) != null) {
            knockbackAttr.setBaseValue(1.0);
        }
    }

    public void cancel() {
        this.cancelled = true;
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.log("\u00a7c\u00a7lTest cancelled!");
        File logFile = this.testLog.saveToFile();
        if (logFile != null) {
            this.log("\u00a77Partial log: \u00a7e" + logFile.getName());
        }
        this.cleanup();
    }

    private void completeTest() {
        this.testLog.logSection("TEST COMPLETE");
        List<String> summary = this.report.generateSummary();
        for (String line : summary) {
            this.testLog.log(line.replace("&", ""));
        }
        File logFile = this.testLog.saveToFile();
        this.log("");
        this.log("\u00a7a\u00a7l=== TEST COMPLETE ===");
        for (String line : summary) {
            this.log(line.replace("&", "\u00a7"));
        }
        if (logFile != null) {
            this.log("\u00a77Log saved: \u00a7e" + logFile.getAbsolutePath());
        }
        this.cleanup();
    }

    private void cleanup() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        if (this.progressBar != null) {
            this.progressBar.removeAll();
            this.progressBar = null;
        }
        this.combatSimulator.removeAllDummies();
        this.restorePlayerState();
        activeSessions.remove(this.playerUUID);
    }

    private void log(String message) {
        this.player.sendMessage(message);
    }

    private void updateProgressBar(String action, int current, int max, BarColor color) {
        if (this.progressBar == null) {
            return;
        }
        this.progressBar.setTitle("\u00a7f" + action + " \u00a77[" + current + "/" + max + "]");
        this.progressBar.setProgress(Math.min(1.0, (double)current / (double)max));
        this.progressBar.setColor(color);
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

