/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.tridents;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class UndertowSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "tridents_undertow";
    private static final double BASE_PROC_CHANCE = 0.2;
    private static final double BASE_PULL_STRENGTH = 1.0;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public UndertowSkill() {
        super(SkillType.TRIDENTS, 50, "Undertow", "Trident attacks have a chance to pull targets toward the player.", SkillBonusType.PROC, 3, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.4, 0.2 + (double)skillLevel * 0.002);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        LivingEntity target = eliteEntity.getLivingEntity();
        int skillLevel = this.getPlayerSkillLevel(player);
        double pullStrength = this.calculatePullStrength(skillLevel);
        Vector direction = player.getLocation().toVector().subtract(target.getLocation().toVector());
        if (direction.lengthSquared() < 0.001) {
            return;
        }
        direction.normalize().multiply(pullStrength);
        direction.setY(0.2);
        target.setVelocity(direction);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a73UNDERTOW!"));
    }

    private double calculatePullStrength(int skillLevel) {
        if (this.configFields != null) {
            return 1.0 + this.configFields.calculateValue(skillLevel);
        }
        return 1.0 + (double)skillLevel * 0.01;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.TRIDENTS);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double procChance = this.getProcChance(skillLevel) * 100.0;
        double pullStrength = this.calculatePullStrength(skillLevel);
        return List.of("&7Chance: &f" + String.format("%.1f", procChance) + "%", "&7Pull Strength: &f" + String.format("%.1f", pullStrength), "&7Pulls targets toward you");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculatePullStrength(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f Pull Strength", this.calculatePullStrength(skillLevel));
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

