/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.tridents;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class TidalSurgeSkill
extends SkillBonus
implements CooldownSkill {
    public static final String SKILL_ID = "tridents_tidal_surge";
    private static final long BASE_COOLDOWN = 20L;
    private static final double SURGE_RADIUS = 5.0;
    private static final Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public TidalSurgeSkill() {
        super(SkillType.TRIDENTS, 25, "Tidal Surge", "Creates a water surge that knocks back and damages nearby enemies.", SkillBonusType.COOLDOWN, 2, SKILL_ID);
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        return Math.max(10L, 20L - (long)(skillLevel / 10));
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long endTime = cooldownMap.get(player.getUniqueId());
        if (endTime == null) {
            return false;
        }
        if (System.currentTimeMillis() >= endTime) {
            cooldownMap.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public void startCooldown(Player player, int skillLevel) {
        long cooldownMs = this.getCooldownSeconds(skillLevel) * 1000L;
        cooldownMap.put(player.getUniqueId(), System.currentTimeMillis() + cooldownMs);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        Long endTime = cooldownMap.get(player.getUniqueId());
        if (endTime == null) {
            return 0L;
        }
        long remaining = (endTime - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    @Override
    public void endCooldown(Player player) {
        cooldownMap.remove(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivate(Player player, Object event) {
        if (!(event instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent damageEvent = (EliteMobDamagedByPlayerEvent)((Object)event);
        if (this.isOnCooldown(player)) {
            return;
        }
        EliteEntity eliteEntity = damageEvent.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        LivingEntity target = eliteEntity.getLivingEntity();
        int skillLevel = this.getPlayerSkillLevel(player);
        this.startCooldown(player, skillLevel);
        target.getWorld().spawnParticle(Particle.SPLASH, target.getLocation(), 100, 2.0, 1.0, 2.0, 0.1);
        double knockbackStrength = this.calculateKnockback(skillLevel);
        double aoeDamageMultiplier = this.calculateAoeDamage(skillLevel);
        EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
        try {
            target.getNearbyEntities(5.0, 5.0, 5.0).stream().filter(e -> e instanceof LivingEntity && !(e instanceof Player)).forEach(e -> {
                Vector direction = e.getLocation().toVector().subtract(target.getLocation().toVector());
                if (direction.lengthSquared() < 0.001) {
                    direction = new Vector(Math.random() - 0.5, 0.0, Math.random() - 0.5);
                }
                direction.normalize().multiply(knockbackStrength);
                direction.setY(0.5);
                e.setVelocity(direction);
                ((LivingEntity)e).damage(damageEvent.getDamage() * aoeDamageMultiplier, (Entity)player);
            });
        }
        finally {
            EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a79TIDAL SURGE!"));
    }

    private double calculateKnockback(int skillLevel) {
        if (this.configFields != null) {
            return 1.5 + this.configFields.calculateValue(skillLevel) * 0.5;
        }
        return 1.5 + (double)skillLevel * 0.01;
    }

    private double calculateAoeDamage(int skillLevel) {
        if (this.configFields != null) {
            return 0.3 * this.configFields.calculateValue(skillLevel);
        }
        return 0.3 + (double)skillLevel * 0.005;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.TRIDENTS);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.endCooldown(player);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.endCooldown(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        long cooldown = this.getCooldownSeconds(skillLevel);
        double knockback = this.calculateKnockback(skillLevel);
        return List.of("&7Cooldown: &f" + cooldown + "s", "&7Knockback: &f" + String.format("%.1f", knockback), "&7Radius: &f5.0 blocks");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculateKnockback(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f Knockback", this.calculateKnockback(skillLevel));
    }

    @Override
    public void shutdown() {
        cooldownMap.clear();
        activePlayers.clear();
    }
}

