/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.tridents;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SnareSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "tridents_snare";
    private static final double BASE_PROC_CHANCE = 0.25;
    private static final int SNARE_DURATION = 60;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public SnareSkill() {
        super(SkillType.TRIDENTS, 10, "Snare", "Trident attacks have a chance to heavily slow and ground targets.", SkillBonusType.PROC, 1, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.45, 0.25 + (double)skillLevel * 0.002);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        LivingEntity target = eliteEntity.getLivingEntity();
        int skillLevel = this.getPlayerSkillLevel(player);
        int amplifier = this.calculateAmplifier(skillLevel);
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, 3 + amplifier));
        target.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, 60, 128));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a7bSNARED!"));
    }

    private int calculateAmplifier(int skillLevel) {
        if (this.configFields != null) {
            return (int)Math.floor(this.configFields.calculateValue(skillLevel));
        }
        return (int)Math.floor((double)skillLevel * 0.05);
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.TRIDENTS);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double procChance = this.getProcChance(skillLevel) * 100.0;
        int amplifier = this.calculateAmplifier(skillLevel);
        return List.of("&7Chance: &f" + String.format("%.1f", procChance) + "%", "&7Slowness Level: &f" + (4 + amplifier), "&7Duration: &f3 seconds");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculateAmplifier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("Slowness %d", 4 + this.calculateAmplifier(skillLevel));
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

