/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.tridents;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.StackingSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class ReturningHasteSkill
extends SkillBonus
implements StackingSkill {
    public static final String SKILL_ID = "tridents_returning_haste";
    private static final int BASE_MAX_STACKS = 5;
    private static final long STACK_DECAY_TIME = 5000L;
    private static final double BASE_BONUS_PER_STACK = 0.1;
    private static final Map<UUID, Integer> playerStacks = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastThrowTime = new HashMap<UUID, Long>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public ReturningHasteSkill() {
        super(SkillType.TRIDENTS, 50, "Returning Haste", "Build stacks with consecutive trident throws. Each stack increases damage.", SkillBonusType.STACKING, 3, SKILL_ID);
    }

    @Override
    public int getMaxStacks() {
        if (this.configFields != null && this.configFields.getMaxStacks() > 0) {
            return this.configFields.getMaxStacks();
        }
        return 5;
    }

    @Override
    public int getCurrentStacks(Player player) {
        Long lastThrow = lastThrowTime.get(player.getUniqueId());
        if (lastThrow != null && System.currentTimeMillis() - lastThrow > 5000L) {
            this.resetStacks(player);
        }
        return playerStacks.getOrDefault(player.getUniqueId(), 0);
    }

    @Override
    public void addStack(Player player) {
        int current = this.getCurrentStacks(player);
        if (current < this.getMaxStacks()) {
            playerStacks.put(player.getUniqueId(), current + 1);
        }
        lastThrowTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @Override
    public void resetStacks(Player player) {
        playerStacks.remove(player.getUniqueId());
        lastThrowTime.remove(player.getUniqueId());
    }

    @Override
    public double getBonusPerStack(int skillLevel) {
        if (this.configFields != null) {
            return 0.1 + this.configFields.calculateValue(skillLevel) * 0.01;
        }
        return 0.1 + (double)skillLevel * 0.002;
    }

    @Override
    public double getTotalStackBonus(Player player, int skillLevel) {
        return (double)this.getCurrentStacks(player) * this.getBonusPerStack(skillLevel);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.resetStacks(player);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.resetStacks(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonusPerStack = this.getBonusPerStack(skillLevel) * 100.0;
        double maxBonus = bonusPerStack * (double)this.getMaxStacks();
        return List.of("&7Max Stacks: &f" + this.getMaxStacks(), "&7Per Stack: &f+" + String.format("%.1f", bonusPerStack) + "%", "&7Max Bonus: &f+" + String.format("%.1f", maxBonus) + "%", "&7Decay: &f5 seconds");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getBonusPerStack(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% per stack", this.getBonusPerStack(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        playerStacks.clear();
        lastThrowTime.clear();
        activePlayers.clear();
    }
}

