/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.tridents;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class LeviathanWrathSkill
extends SkillBonus
implements CooldownSkill {
    public static final String SKILL_ID = "tridents_leviathan_wrath";
    private static final long BASE_COOLDOWN = 60L;
    private static final double AOE_RADIUS = 6.0;
    private static final double BASE_DAMAGE_MULTIPLIER = 2.0;
    private static final Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public LeviathanWrathSkill() {
        super(SkillType.TRIDENTS, 75, "Leviathan's Wrath", "Massive AOE water attack with lightning strikes. Deals massive damage to all nearby enemies.", SkillBonusType.COOLDOWN, 4, SKILL_ID);
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        return Math.max(30L, 60L - (long)(skillLevel / 5));
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long endTime = cooldownMap.get(player.getUniqueId());
        if (endTime == null) {
            return false;
        }
        if (System.currentTimeMillis() >= endTime) {
            cooldownMap.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public void startCooldown(Player player, int skillLevel) {
        long cooldownMs = this.getCooldownSeconds(skillLevel) * 1000L;
        cooldownMap.put(player.getUniqueId(), System.currentTimeMillis() + cooldownMs);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        Long endTime = cooldownMap.get(player.getUniqueId());
        if (endTime == null) {
            return 0L;
        }
        long remaining = (endTime - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    @Override
    public void endCooldown(Player player) {
        cooldownMap.remove(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivate(Player player, Object event) {
        if (!(event instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent damageEvent = (EliteMobDamagedByPlayerEvent)((Object)event);
        if (this.isOnCooldown(player)) {
            return;
        }
        EliteEntity eliteEntity = damageEvent.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        LivingEntity target = eliteEntity.getLivingEntity();
        int skillLevel = this.getPlayerSkillLevel(player);
        this.startCooldown(player, skillLevel);
        target.getWorld().spawnParticle(Particle.SPLASH, target.getLocation(), 200, 3.0, 2.0, 3.0, 0.5);
        target.getWorld().playSound(target.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, 1.0f, 0.5f);
        for (int i = 0; i < 3; ++i) {
            target.getWorld().strikeLightningEffect(target.getLocation().add((Math.random() - 0.5) * 6.0, 0.0, (Math.random() - 0.5) * 6.0));
        }
        double aoeDamage = damageEvent.getDamage() * this.calculateDamageMultiplier(skillLevel);
        EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
        try {
            target.getNearbyEntities(6.0, 6.0, 6.0).stream().filter(e -> e instanceof LivingEntity && !(e instanceof Player)).forEach(e -> ((LivingEntity)e).damage(aoeDamage, (Entity)player));
        }
        finally {
            EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a75LEVIATHAN'S WRATH!"));
    }

    private double calculateDamageMultiplier(int skillLevel) {
        if (this.configFields != null) {
            return 2.0 + this.configFields.calculateValue(skillLevel);
        }
        return 2.0 + (double)skillLevel * 0.02;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.TRIDENTS);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.endCooldown(player);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.endCooldown(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        long cooldown = this.getCooldownSeconds(skillLevel);
        double damageMultiplier = this.calculateDamageMultiplier(skillLevel);
        return List.of("&7Cooldown: &f" + cooldown + "s", "&7Damage Multiplier: &f" + String.format("%.1f", damageMultiplier) + "x", "&7Radius: &f6.0 blocks", "&7Lightning strikes + AOE damage");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculateDamageMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1fx AOE Damage", this.calculateDamageMultiplier(skillLevel));
    }

    @Override
    public void shutdown() {
        cooldownMap.clear();
        activePlayers.clear();
    }
}

