/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class SwiftStrikesSkill
extends SkillBonus {
    public static final String SKILL_ID = "swords_swift_strikes";
    private static final double BASE_SPEED_BONUS = 0.05;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public SwiftStrikesSkill() {
        super(SkillType.SWORDS, 10, "Swift Strikes", "Move faster while wielding a sword.", SkillBonusType.PASSIVE, 1, SKILL_ID);
    }

    public static double getSpeedBonus(int skillLevel) {
        return Math.min(0.15, 0.05 + (double)skillLevel * 0.001);
    }

    public static boolean hasActiveSkill(UUID playerUUID) {
        return activePlayers.contains(playerUUID);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double speed = SwiftStrikesSkill.getSpeedBonus(skillLevel) * 100.0;
        return List.of("&7Movement Speed: &f+" + String.format("%.1f", speed) + "%", "&7Active while holding a sword");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return SwiftStrikesSkill.getSpeedBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% Movement Speed", SwiftStrikesSkill.getSpeedBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

