/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RiposteSkill
extends SkillBonus
implements CooldownSkill {
    public static final String SKILL_ID = "swords_riposte";
    private static final double BASE_COOLDOWN = 10.0;
    private static final double BASE_DAMAGE_MULTIPLIER = 1.5;
    private static final Set<UUID> playersOnCooldown = new HashSet<UUID>();
    private static final Set<UUID> playersWithRiposteReady = new HashSet<UUID>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public RiposteSkill() {
        super(SkillType.SWORDS, 25, "Riposte", "After blocking an attack, your next attack deals bonus damage.", SkillBonusType.COOLDOWN, 2, SKILL_ID);
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        double reduction = 1.0 - (double)skillLevel * 0.005;
        return (long)Math.max(5.0, 10.0 * reduction);
    }

    @Override
    public boolean isOnCooldown(Player player) {
        return playersOnCooldown.contains(player.getUniqueId());
    }

    @Override
    public void startCooldown(Player player, int skillLevel) {
        final UUID uuid = player.getUniqueId();
        playersOnCooldown.add(uuid);
        long seconds = this.getCooldownSeconds(skillLevel);
        new BukkitRunnable(this){

            public void run() {
                playersOnCooldown.remove(uuid);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, seconds * 20L);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        return 0L;
    }

    @Override
    public void endCooldown(Player player) {
        playersOnCooldown.remove(player.getUniqueId());
    }

    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        if (!playersWithRiposteReady.contains(player.getUniqueId())) {
            return;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.SWORDS);
        double multiplier = this.getDamageMultiplier(skillLevel);
        event.setDamage(event.getDamage() * multiplier);
        playersWithRiposteReady.remove(player.getUniqueId());
        this.startCooldown(player, skillLevel);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a76Riposte!"));
    }

    public static void onPlayerBlock(Player player) {
        final UUID uuid = player.getUniqueId();
        if (!activePlayers.contains(uuid)) {
            return;
        }
        if (playersOnCooldown.contains(uuid)) {
            return;
        }
        playersWithRiposteReady.add(uuid);
        new BukkitRunnable(){

            public void run() {
                playersWithRiposteReady.remove(uuid);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 60L);
    }

    public static boolean hasRiposteReady(UUID playerUUID) {
        return playersWithRiposteReady.contains(playerUUID);
    }

    private double getDamageMultiplier(int skillLevel) {
        return 1.5 + (double)skillLevel * 0.01;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        UUID uuid = player.getUniqueId();
        activePlayers.remove(uuid);
        playersOnCooldown.remove(uuid);
        playersWithRiposteReady.remove(uuid);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.removeBonus(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double multiplier = (this.getDamageMultiplier(skillLevel) - 1.0) * 100.0;
        double cooldown = this.getCooldownSeconds(skillLevel);
        return List.of("&7Bonus Damage: &f+" + String.format("%.0f", multiplier) + "%", "&7Cooldown: &f" + String.format("%.1f", cooldown) + "s", "&7Block to activate, then attack within 3s");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getDamageMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.0f%% Riposte Damage", (this.getDamageMultiplier(skillLevel) - 1.0) * 100.0);
    }

    @Override
    public void shutdown() {
        playersOnCooldown.clear();
        playersWithRiposteReady.clear();
        activePlayers.clear();
    }
}

