/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.api.PlayerDamagedByEliteMobEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ParrySkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "swords_parry";
    private static final double BASE_DAMAGE_REDUCTION = 0.3;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public ParrySkill() {
        super(SkillType.SWORDS, 50, "Parry", "Block attacks with your sword to reduce damage further.", SkillBonusType.CONDITIONAL, 3, SKILL_ID);
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        if (!(context instanceof PlayerDamagedByEliteMobEvent)) {
            return false;
        }
        if (!player.isBlocking()) {
            return false;
        }
        Material mainHand = player.getInventory().getItemInMainHand().getType();
        return mainHand.name().endsWith("_SWORD");
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return Math.min(0.6, 0.3 + (double)skillLevel * 0.005);
    }

    public static double applyParryReduction(Player player, PlayerDamagedByEliteMobEvent event, double currentDamage) {
        if (!activePlayers.contains(player.getUniqueId())) {
            return currentDamage;
        }
        if (!player.isBlocking()) {
            return currentDamage;
        }
        Material mainHand = player.getInventory().getItemInMainHand().getType();
        if (!mainHand.name().endsWith("_SWORD")) {
            return currentDamage;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.SWORDS);
        double reduction = Math.min(0.6, 0.3 + (double)skillLevel * 0.005);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a7aParry!"));
        return currentDamage * (1.0 - reduction);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double reduction = this.getConditionalBonus(skillLevel) * 100.0;
        return List.of("&7Damage Reduction: &f" + String.format("%.1f", reduction) + "%", "&7Condition: Blocking with sword", "&7Stacks with normal blocking");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("-%.1f%% Damage when Parrying", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

