/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ExposeWeaknessSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "swords_expose_weakness";
    private static final double BASE_PROC_CHANCE = 0.2;
    private static final double BASE_DEFENSE_REDUCTION = 0.1;
    private static final int DEBUFF_DURATION_TICKS = 100;
    private static final Map<UUID, DebuffData> debuffedEntities = new HashMap<UUID, DebuffData>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public ExposeWeaknessSkill() {
        super(SkillType.SWORDS, 25, "Expose Weakness", "Attacks have a chance to reduce the target's defense.", SkillBonusType.PROC, 2, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.5, 0.2 + (double)skillLevel * 0.003);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity target = event.getEliteMobEntity();
        if (target == null || target.getLivingEntity() == null) {
            return;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.SWORDS);
        this.applyDebuff(target, skillLevel);
    }

    private void applyDebuff(EliteEntity target, int skillLevel) {
        final UUID entityUUID = target.getLivingEntity().getUniqueId();
        DebuffData existing = debuffedEntities.get(entityUUID);
        if (existing != null) {
            existing.cancel();
        }
        double reduction = this.getDefenseReduction(skillLevel);
        BukkitRunnable expiryTask = new BukkitRunnable(this){

            public void run() {
                debuffedEntities.remove(entityUUID);
            }
        };
        expiryTask.runTaskLater((Plugin)MetadataHandler.PLUGIN, 100L);
        debuffedEntities.put(entityUUID, new DebuffData(reduction, expiryTask));
        if (target.getLivingEntity() != null) {
            target.getLivingEntity().getWorld().spawnParticle(Particle.ENCHANT, target.getLivingEntity().getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0);
        }
    }

    public static double getDamageMultiplier(UUID entityUUID) {
        DebuffData data = debuffedEntities.get(entityUUID);
        if (data == null) {
            return 1.0;
        }
        return 1.0 + data.defenseReduction;
    }

    public static boolean isDebuffed(UUID entityUUID) {
        return debuffedEntities.containsKey(entityUUID);
    }

    private double getDefenseReduction(int skillLevel) {
        return 0.1 + (double)skillLevel * 0.002;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double proc = this.getProcChance(skillLevel) * 100.0;
        double reduction = this.getDefenseReduction(skillLevel) * 100.0;
        return List.of("&7Proc Chance: &f" + String.format("%.1f", proc) + "%", "&7Defense Reduction: &f" + String.format("%.1f", reduction) + "%", "&7Duration: &f5 seconds");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getDefenseReduction(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("-%.1f%% Target Defense", this.getDefenseReduction(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        for (DebuffData data : debuffedEntities.values()) {
            data.cancel();
        }
        debuffedEntities.clear();
        activePlayers.clear();
    }

    private static class DebuffData {
        final double defenseReduction;
        final BukkitRunnable expiryTask;

        DebuffData(double defenseReduction, BukkitRunnable expiryTask) {
            this.defenseReduction = defenseReduction;
            this.expiryTask = expiryTask;
        }

        void cancel() {
            if (this.expiryTask != null) {
                this.expiryTask.cancel();
            }
        }
    }
}

