/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusEventHandler;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ToggleSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class BladeDanceSkill
extends SkillBonus
implements ToggleSkill {
    public static final String SKILL_ID = "swords_blade_dance";
    private static final double BASE_DODGE_CHANCE = 0.15;
    private static final double BASE_DAMAGE_PENALTY = 0.2;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();
    private static final Set<UUID> toggledPlayers = new HashSet<UUID>();

    public BladeDanceSkill() {
        super(SkillType.SWORDS, 75, "Blade Dance", "Toggle: Gain dodge chance but deal less damage.", SkillBonusType.TOGGLE, 4, SKILL_ID);
    }

    @Override
    public void toggle(Player player) {
        UUID uuid = player.getUniqueId();
        if (toggledPlayers.contains(uuid)) {
            this.disable(player);
        } else {
            this.enable(player);
        }
    }

    @Override
    public boolean isToggled(Player player) {
        return toggledPlayers.contains(player.getUniqueId());
    }

    @Override
    public void enable(Player player) {
        toggledPlayers.add(player.getUniqueId());
        SkillBonusEventHandler.setToggle(player.getUniqueId(), SKILL_ID, true);
        player.sendMessage("\u00a76Blade Dance \u00a7aenabled\u00a77 - Dodge increased, damage reduced");
    }

    @Override
    public void disable(Player player) {
        toggledPlayers.remove(player.getUniqueId());
        SkillBonusEventHandler.setToggle(player.getUniqueId(), SKILL_ID, false);
        player.sendMessage("\u00a76Blade Dance \u00a7cdisabled");
    }

    @Override
    public double getPositiveBonus(int skillLevel) {
        return Math.min(0.4, 0.15 + (double)skillLevel * 0.003);
    }

    @Override
    public double getNegativeEffect(int skillLevel) {
        return Math.max(0.05, 0.2 - (double)skillLevel * 0.002);
    }

    public static double getDodgeChance(Player player, int skillLevel) {
        if (!toggledPlayers.contains(player.getUniqueId())) {
            return 0.0;
        }
        return Math.min(0.4, 0.15 + (double)skillLevel * 0.003);
    }

    public static double getDamageMultiplier(Player player, int skillLevel) {
        if (!toggledPlayers.contains(player.getUniqueId())) {
            return 1.0;
        }
        double penalty = Math.max(0.05, 0.2 - (double)skillLevel * 0.002);
        return 1.0 - penalty;
    }

    public static boolean hasActiveToggle(UUID playerUUID) {
        return toggledPlayers.contains(playerUUID);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        UUID uuid = player.getUniqueId();
        activePlayers.remove(uuid);
        toggledPlayers.remove(uuid);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.removeBonus(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double dodge = this.getPositiveBonus(skillLevel) * 100.0;
        double penalty = this.getNegativeEffect(skillLevel) * 100.0;
        return List.of("&aPositive: &f+" + String.format("%.1f", dodge) + "% Dodge Chance", "&cNegative: &f-" + String.format("%.1f", penalty) + "% Damage", "&7Right-click with sword to toggle");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getPositiveBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% Dodge (toggle)", this.getPositiveBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        toggledPlayers.clear();
    }
}

