/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public class SoulDrainSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "hoes_soul_drain";
    private static final double BASE_PROC_CHANCE = 0.2;
    private static final double BASE_DRAIN_MULTIPLIER = 0.3;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public SoulDrainSkill() {
        super(SkillType.HOES, 10, "Soul Drain", "Attacks have a chance to drain health from enemies.", SkillBonusType.PROC, 1, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.5, 0.2 + (double)skillLevel * 0.002);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        double damage = event.getDamage();
        int skillLevel = this.getPlayerSkillLevel(player);
        double drainAmount = damage * this.calculateDrainMultiplier(skillLevel);
        double newHealth = Math.min(player.getHealth() + drainAmount, player.getMaxHealth());
        player.setHealth(newHealth);
        eliteEntity.getLivingEntity().getWorld().spawnParticle(Particle.SOUL, eliteEntity.getLivingEntity().getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.5, 0.3, 0.05);
    }

    private double calculateDrainMultiplier(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 0.3 + (double)skillLevel * 0.005;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.HOES);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double procChance = this.getProcChance(skillLevel) * 100.0;
        double drainPercent = this.calculateDrainMultiplier(skillLevel) * 100.0;
        return List.of("&7Chance: &f" + String.format("%.1f", procChance) + "%", "&7Drain: &f" + String.format("%.1f", drainPercent) + "% of damage", "&7Heals you for damage dealt");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculateDrainMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f%% Life Drain", this.calculateDrainMultiplier(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

