/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class HarvesterSkill
extends SkillBonus {
    public static final String SKILL_ID = "hoes_harvester";
    private static final double BASE_DAMAGE_BONUS = 0.1;
    private static final double BASE_LOOT_BONUS = 0.15;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public HarvesterSkill() {
        super(SkillType.HOES, 25, "Harvester", "Reap better rewards from your enemies.", SkillBonusType.PASSIVE, 2, SKILL_ID);
    }

    public double getDamageBonus(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 0.1 + (double)skillLevel * 0.002;
    }

    public double getLootBonus(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel) * 1.5;
        }
        return 0.15 + (double)skillLevel * 0.003;
    }

    public static double getLootMultiplier(Player player) {
        if (!activePlayers.contains(player.getUniqueId())) {
            return 1.0;
        }
        SkillBonus skill = SkillBonusRegistry.getSkillById(SKILL_ID);
        if (!(skill instanceof HarvesterSkill)) {
            return 1.0;
        }
        HarvesterSkill harvester = (HarvesterSkill)skill;
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.HOES);
        return 1.0 + harvester.getLootBonus(skillLevel);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double damagePercent = this.getDamageBonus(skillLevel) * 100.0;
        double lootPercent = this.getLootBonus(skillLevel) * 100.0;
        return List.of("&7Damage Bonus: &f+" + String.format("%.1f", damagePercent) + "%", "&7Loot Quality: &f+" + String.format("%.1f", lootPercent) + "%", "&7Passive harvest benefits");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getDamageBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% Damage & Loot", this.getDamageBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

