/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class GrimReachSkill
extends SkillBonus {
    public static final String SKILL_ID = "hoes_grim_reach";
    private static final double BASE_DAMAGE_BONUS = 0.15;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public GrimReachSkill() {
        super(SkillType.HOES, 10, "Grim Reach", "Extended reach allows you to deal more damage.", SkillBonusType.PASSIVE, 1, SKILL_ID);
    }

    public double getDamageMultiplier(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 0.15 + (double)skillLevel * 0.003;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonusPercent = this.getDamageMultiplier(skillLevel) * 100.0;
        return List.of("&7Damage Bonus: &f+" + String.format("%.1f", bonusPercent) + "%", "&7Extended attack range", "&7Always active");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getDamageMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% Damage", this.getDamageMultiplier(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

