/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ToggleSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DreadAuraSkill
extends SkillBonus
implements ToggleSkill {
    public static final String SKILL_ID = "hoes_dread_aura";
    private static final double AURA_RADIUS = 5.0;
    private static final double BASE_DAMAGE_BONUS = 0.25;
    private static final double BASE_NEGATIVE_EFFECT = 0.1;
    private static final Set<UUID> toggledPlayers = new HashSet<UUID>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public DreadAuraSkill() {
        super(SkillType.HOES, 50, "Dread Aura", "Toggle an aura that weakens nearby enemies.", SkillBonusType.TOGGLE, 3, SKILL_ID);
    }

    @Override
    public void toggle(Player player) {
        if (this.isToggled(player)) {
            this.disable(player);
        } else {
            this.enable(player);
        }
    }

    @Override
    public boolean isToggled(Player player) {
        return toggledPlayers.contains(player.getUniqueId());
    }

    @Override
    public void enable(Player player) {
        toggledPlayers.add(player.getUniqueId());
    }

    @Override
    public void disable(Player player) {
        toggledPlayers.remove(player.getUniqueId());
    }

    @Override
    public double getPositiveBonus(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 0.25 + (double)skillLevel * 0.005;
    }

    @Override
    public double getNegativeEffect(int skillLevel) {
        return 0.1;
    }

    public static void applyAuraEffects(Player player) {
        if (!toggledPlayers.contains(player.getUniqueId())) {
            return;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.HOES);
        player.getNearbyEntities(5.0, 5.0, 5.0).stream().filter(e -> e instanceof LivingEntity && !(e instanceof Player)).forEach(e -> {
            LivingEntity mob = (LivingEntity)e;
            int amplifier = Math.min(2, (int)Math.floor((double)skillLevel / 25.0));
            mob.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 40, amplifier));
            mob.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 1));
        });
        if (player.getTicksLived() % 20 == 0) {
            player.getWorld().spawnParticle(Particle.SCULK_CHARGE_POP, player.getLocation(), 5, 2.0, 0.5, 2.0, 0.01);
        }
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        this.disable(player);
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.disable(player);
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonusPercent = this.getPositiveBonus(skillLevel) * 100.0;
        return List.of("&7Damage Bonus: &f+" + String.format("%.1f", bonusPercent) + "%", "&7Radius: &f" + String.format("%.1f", 5.0) + " blocks", "&7Weakens nearby enemies", "&7Toggle to activate/deactivate");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getPositiveBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% Damage (Aura)", this.getPositiveBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        toggledPlayers.clear();
        activePlayers.clear();
    }
}

