/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.crossbows;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class SteadyAimSkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "crossbows_steady_aim";
    private static final long STAND_TIME_REQUIRED = 1500L;
    private static final double BASE_BONUS = 0.2;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();
    private static final Map<UUID, Long> standingStillSince = new HashMap<UUID, Long>();

    public SteadyAimSkill() {
        super(SkillType.CROSSBOWS, 10, "Steady Aim", "Standing still increases your damage.", SkillBonusType.CONDITIONAL, 1, SKILL_ID);
    }

    public static void updatePlayerMovement(UUID uuid, boolean isMoving) {
        if (isMoving) {
            standingStillSince.remove(uuid);
        } else if (!standingStillSince.containsKey(uuid)) {
            standingStillSince.put(uuid, System.currentTimeMillis());
        }
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        Long stillSince = standingStillSince.get(player.getUniqueId());
        if (stillSince == null) {
            return false;
        }
        return System.currentTimeMillis() - stillSince >= 1500L;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return 0.2 + (double)skillLevel * 0.003;
    }

    public double calculateBonus(Player player, int skillLevel) {
        Long stillSince = standingStillSince.get(player.getUniqueId());
        if (stillSince == null) {
            return 0.0;
        }
        long standTime = System.currentTimeMillis() - stillSince;
        if (standTime < 1500L) {
            return 0.0;
        }
        double timeBonus = Math.min((double)(standTime - 1500L) / 1500.0, 2.0);
        return this.getConditionalBonus(skillLevel) * (1.0 + timeBonus);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        standingStillSince.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        standingStillSince.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Base Bonus: &f" + String.format("%.1f", this.getConditionalBonus(skillLevel) * 100.0) + "%", "&7Max Bonus: &f3x base", "&7Stand still for 1.5s to activate");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel) * 3.0;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% when stationary", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        standingStillSince.clear();
    }
}

