/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.crossbows;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class QuickReloadSkill
extends SkillBonus {
    public static final String SKILL_ID = "crossbows_quick_reload";
    private static final int HASTE_DURATION = 60;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public QuickReloadSkill() {
        super(SkillType.CROSSBOWS, 10, "Quick Reload", "Successful hits grant haste for faster reloading.", SkillBonusType.PASSIVE, 1, SKILL_ID);
    }

    public void applyHaste(Player player) {
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.CROSSBOWS);
        int amplifier = Math.min(2, skillLevel / 30);
        player.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, 60, amplifier));
    }

    private int getHasteAmplifier(int skillLevel) {
        return Math.min(2, skillLevel / 30);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Haste Level: &f" + (this.getHasteAmplifier(skillLevel) + 1), "&7Duration: &f3 seconds", "&7Triggers on hit");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getHasteAmplifier(skillLevel) + 1;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("Haste %d on hit", this.getHasteAmplifier(skillLevel) + 1);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

