/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.crossbows;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class HuntersPreySkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "crossbows_hunters_prey";
    private static final double HEALTH_THRESHOLD = 0.5;
    private static final double BASE_BONUS = 0.25;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public HuntersPreySkill() {
        super(SkillType.CROSSBOWS, 25, "Hunter's Prey", "Deal bonus damage to targets below 50% health.", SkillBonusType.CONDITIONAL, 2, SKILL_ID);
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return false;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        if (event.getEliteMobEntity().getLivingEntity() == null) {
            return false;
        }
        double healthPercent = event.getEliteMobEntity().getLivingEntity().getHealth() / event.getEliteMobEntity().getLivingEntity().getMaxHealth();
        return healthPercent < 0.5;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return 0.25 + (double)skillLevel * 0.004;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Bonus Damage: &f" + String.format("%.1f", this.getConditionalBonus(skillLevel) * 100.0) + "%", "&7Threshold: &fBelow 50% HP");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% to low HP targets", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

