/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.crossbows;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ArrowRainSkill
extends SkillBonus
implements CooldownSkill {
    public static final String SKILL_ID = "crossbows_arrow_rain";
    private static final long BASE_COOLDOWN = 30L;
    private static final double BASE_ARROW_DAMAGE = 0.3;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();
    private static final Set<UUID> onCooldown = new HashSet<UUID>();
    private static final Map<UUID, Long> cooldownEndTimes = new HashMap<UUID, Long>();

    public ArrowRainSkill() {
        super(SkillType.CROSSBOWS, 75, "Arrow Rain", "Rain arrows on the target location.", SkillBonusType.COOLDOWN, 4, SKILL_ID);
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        return Math.max(15L, 30L - (long)(skillLevel / 5));
    }

    @Override
    public boolean isOnCooldown(Player player) {
        return onCooldown.contains(player.getUniqueId());
    }

    @Override
    public void startCooldown(final Player player, int skillLevel) {
        UUID uuid = player.getUniqueId();
        long cooldownMs = this.getCooldownSeconds(skillLevel) * 1000L;
        onCooldown.add(uuid);
        cooldownEndTimes.put(uuid, System.currentTimeMillis() + cooldownMs);
        new BukkitRunnable(){

            public void run() {
                ArrowRainSkill.this.endCooldown(player);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, this.getCooldownSeconds(skillLevel) * 20L);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        Long endTime = cooldownEndTimes.get(player.getUniqueId());
        if (endTime == null) {
            return 0L;
        }
        long remaining = endTime - System.currentTimeMillis();
        return remaining > 0L ? remaining / 1000L : 0L;
    }

    @Override
    public void endCooldown(Player player) {
        onCooldown.remove(player.getUniqueId());
        cooldownEndTimes.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(final Player player, Object event) {
        if (!(event instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent damageEvent = (EliteMobDamagedByPlayerEvent)((Object)event);
        if (damageEvent.getEliteMobEntity().getLivingEntity() == null) {
            return;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.CROSSBOWS);
        final double arrowDamage = damageEvent.getDamage() * this.getArrowDamageMultiplier(skillLevel);
        final Location targetLoc = damageEvent.getEliteMobEntity().getLivingEntity().getLocation().add(0.0, 10.0, 0.0);
        new BukkitRunnable(this){
            int count = 0;

            public void run() {
                if (this.count >= 5) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    Location spawnLoc = targetLoc.clone().add(ThreadLocalRandom.current().nextDouble(-2.0, 2.0), 0.0, ThreadLocalRandom.current().nextDouble(-2.0, 2.0));
                    Arrow arrow = (Arrow)player.getWorld().spawn(spawnLoc, Arrow.class);
                    arrow.setShooter((ProjectileSource)player);
                    arrow.setVelocity(new Vector(0, -2, 0));
                    arrow.setDamage(arrowDamage);
                    arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                }
                ++this.count;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 5L);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a7b\u00a7lARROW RAIN!"));
    }

    private double getArrowDamageMultiplier(int skillLevel) {
        return 0.3 + (double)skillLevel * 0.005;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.endCooldown(player);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.endCooldown(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Arrow Damage: &f" + String.format("%.0f", this.getArrowDamageMultiplier(skillLevel) * 100.0) + "%", "&7Arrows: &f15 total (3x5 waves)", "&7Cooldown: &f" + this.getCooldownSeconds(skillLevel) + "s");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getArrowDamageMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.0f%% arrow damage", this.getArrowDamageMultiplier(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        onCooldown.clear();
        cooldownEndTimes.clear();
    }
}

