/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.bows;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.StackingSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class RangersFocusSkill
extends SkillBonus
implements StackingSkill {
    public static final String SKILL_ID = "bows_rangers_focus";
    private static final int MAX_STACKS = 8;
    private static final double BASE_BONUS_PER_STACK = 0.04;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();
    private static final Map<UUID, Integer> playerStacks = new HashMap<UUID, Integer>();
    private static final Map<UUID, UUID> targetedEnemy = new HashMap<UUID, UUID>();

    public RangersFocusSkill() {
        super(SkillType.BOWS, 75, "Ranger's Focus", "Focusing on a single target increases your damage.", SkillBonusType.STACKING, 4, SKILL_ID);
    }

    @Override
    public int getMaxStacks() {
        return 8;
    }

    @Override
    public int getCurrentStacks(Player player) {
        return playerStacks.getOrDefault(player.getUniqueId(), 0);
    }

    @Override
    public void addStack(Player player) {
        int current = this.getCurrentStacks(player);
        if (current < 8) {
            playerStacks.put(player.getUniqueId(), current + 1);
        }
    }

    @Override
    public void resetStacks(Player player) {
        playerStacks.remove(player.getUniqueId());
        targetedEnemy.remove(player.getUniqueId());
    }

    @Override
    public double getBonusPerStack(int skillLevel) {
        return 0.04 + (double)skillLevel * 8.0E-4;
    }

    public UUID getTargetedEnemy(Player player) {
        return targetedEnemy.get(player.getUniqueId());
    }

    public void setTargetedEnemy(Player player, UUID targetUUID) {
        UUID currentTarget = targetedEnemy.get(player.getUniqueId());
        if (currentTarget != null && !currentTarget.equals(targetUUID)) {
            this.resetStacks(player);
        }
        targetedEnemy.put(player.getUniqueId(), targetUUID);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.resetStacks(player);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.resetStacks(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Bonus per Stack: &f" + String.format("%.1f", this.getBonusPerStack(skillLevel) * 100.0) + "%", "&7Max Stacks: &f8", "&7Stacks reset when switching targets");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getBonusPerStack(skillLevel) * 8.0;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% per stack (max %d)", this.getBonusPerStack(skillLevel) * 100.0, 8);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        playerStacks.clear();
        targetedEnemy.clear();
    }
}

