/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.bows;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class MultishotSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "bows_multishot";
    private static final double BASE_PROC_CHANCE = 0.2;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public MultishotSkill() {
        super(SkillType.BOWS, 25, "Multishot", "Chance to fire additional arrows when attacking.", SkillBonusType.PROC, 2, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.4, 0.2 + (double)skillLevel * 0.002);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.BOWS);
        double arrowDamage = event.getDamage() * 0.5;
        Vector direction = player.getLocation().getDirection();
        double spread = 0.15;
        int extraArrows = 2 + skillLevel / 40;
        for (int i = 0; i < extraArrows; ++i) {
            Vector offset = new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) * spread, (ThreadLocalRandom.current().nextDouble() - 0.5) * spread, (ThreadLocalRandom.current().nextDouble() - 0.5) * spread);
            Arrow arrow = (Arrow)player.launchProjectile(Arrow.class, direction.clone().add(offset).normalize().multiply(2));
            arrow.setDamage(arrowDamage);
            arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a7aMULTISHOT!"));
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        int extraArrows = 2 + skillLevel / 40;
        return List.of("&7Proc Chance: &f" + String.format("%.1f", this.getProcChance(skillLevel) * 100.0) + "%", "&7Extra Arrows: &f" + extraArrows, "&7Arrow Damage: &f50% of original");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getProcChance(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.0f%% chance for extra arrows", this.getProcChance(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

