/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.axes;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WoundSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "axes_wound";
    private static final double BASE_PROC_CHANCE = 0.15;
    private static final double BASE_BLEED_DAMAGE = 3.0;
    private static final int BLEED_DURATION = 80;
    private static final Map<UUID, BukkitRunnable> activeWounds = new HashMap<UUID, BukkitRunnable>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public WoundSkill() {
        super(SkillType.AXES, 10, "Wound", "Attacks can inflict deep wounds that bleed heavily.", SkillBonusType.PROC, 1, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.4, 0.15 + (double)skillLevel * 0.003);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity target = event.getEliteMobEntity();
        if (target == null || target.getLivingEntity() == null) {
            return;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.AXES);
        this.applyWound(player, target, skillLevel);
    }

    private void applyWound(final Player player, final EliteEntity target, int skillLevel) {
        final UUID entityUUID = target.getLivingEntity().getUniqueId();
        final double damage = 3.0 + (double)skillLevel * 0.15;
        if (activeWounds.containsKey(entityUUID)) {
            activeWounds.get(entityUUID).cancel();
        }
        BukkitRunnable woundTask = new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks >= 80 || target.getLivingEntity() == null || target.getLivingEntity().isDead()) {
                    activeWounds.remove(entityUUID);
                    this.cancel();
                    return;
                }
                LivingEntity entity = target.getLivingEntity();
                EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
                try {
                    entity.damage(damage, (Entity)player);
                }
                finally {
                    EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
                }
                entity.getWorld().spawnParticle(Particle.BLOCK, entity.getLocation().add(0.0, 1.0, 0.0), 8, 0.3, 0.3, 0.3, 0.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
                this.ticks += 20;
            }
        };
        woundTask.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 20L);
        activeWounds.put(entityUUID, woundTask);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Proc Chance: &f" + String.format("%.1f", this.getProcChance(skillLevel) * 100.0) + "%", "&7Bleed Damage: &f" + String.format("%.1f", 3.0 + (double)skillLevel * 0.15) + "/s", "&7Duration: &f4 seconds");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return 3.0 + (double)skillLevel * 0.15;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f Wound Damage/s", this.getBonusValue(skillLevel));
    }

    @Override
    public void shutdown() {
        for (BukkitRunnable task : activeWounds.values()) {
            task.cancel();
        }
        activeWounds.clear();
        activePlayers.clear();
    }
}

