/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.axes;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public class DevastatingBlowSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "axes_devastating_blow";
    private static final double BASE_PROC_CHANCE = 0.1;
    private static final double BASE_DAMAGE_MULTIPLIER = 2.0;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public DevastatingBlowSkill() {
        super(SkillType.AXES, 10, "Devastating Blow", "Attacks have a chance to deal massive bonus damage.", SkillBonusType.PROC, 1, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.3, 0.1 + (double)skillLevel * 0.002);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.AXES);
        double multiplier = this.getDamageMultiplier(skillLevel);
        event.setDamage(event.getDamage() * multiplier);
        if (event.getEliteMobEntity().getLivingEntity() != null) {
            event.getEliteMobEntity().getLivingEntity().getWorld().spawnParticle(Particle.EXPLOSION, event.getEliteMobEntity().getLivingEntity().getLocation(), 1);
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a7c\u00a7lDEVASTATING BLOW!"));
    }

    private double getDamageMultiplier(int skillLevel) {
        return 2.0 + (double)skillLevel * 0.02;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Proc Chance: &f" + String.format("%.1f", this.getProcChance(skillLevel) * 100.0) + "%", "&7Damage: &f" + String.format("%.1f", this.getDamageMultiplier(skillLevel)) + "x");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getDamageMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1fx Damage (proc)", this.getDamageMultiplier(skillLevel));
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

