/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.armor;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class IronStanceSkill
extends SkillBonus
implements ConditionalSkill {
    private static final HashSet<UUID> activePlayers = new HashSet();
    private static final Map<UUID, Long> lastMoveTime = new HashMap<UUID, Long>();
    private static final long STAND_TIME_REQUIRED = 1000L;

    public IronStanceSkill() {
        super(SkillType.ARMOR, 10, "Iron Stance", "Gain damage reduction when standing still", SkillBonusType.CONDITIONAL, 1, "iron_stance");
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
    }

    @Override
    public void removeBonus(Player player) {
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        lastMoveTime.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Gain damage reduction when standing still");
        lore.add(String.format("Damage Reduction: %.1f%%", this.getConditionalBonus(skillLevel) * 50.0));
        lore.add("Requires: Standing still for 1 second");
        return lore;
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f%% Damage Reduction", this.getConditionalBonus(skillLevel) * 50.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        lastMoveTime.clear();
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        if (!this.isActive(player)) {
            return false;
        }
        Long lastMove = lastMoveTime.get(player.getUniqueId());
        if (lastMove == null) {
            return true;
        }
        return System.currentTimeMillis() - lastMove >= 1000L;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return this.getScaledValue(skillLevel);
    }

    public static void updatePlayerMovement(UUID uuid, boolean isMoving) {
        if (isMoving) {
            lastMoveTime.put(uuid, System.currentTimeMillis());
        }
    }

    public double modifyIncomingDamage(Player player, double originalDamage, Object context) {
        if (this.conditionMet(player, context)) {
            int skillLevel = this.getPlayerSkillLevel(player);
            return originalDamage * (1.0 - this.getConditionalBonus(skillLevel) * 0.5);
        }
        return originalDamage;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.ARMOR);
    }
}

