/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.armor;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class GritSkill
extends SkillBonus
implements ConditionalSkill {
    private static final HashSet<UUID> activePlayers = new HashSet();
    private static final double HEALTH_THRESHOLD = 0.5;

    public GritSkill() {
        super(SkillType.ARMOR, 50, "Grit", "Gain increased damage reduction when below 50% health", SkillBonusType.CONDITIONAL, 3, "grit");
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
    }

    @Override
    public void removeBonus(Player player) {
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Gain increased damage reduction when below 50% health");
        lore.add("Lower health = more damage reduction");
        lore.add(String.format("Max Reduction: %.1f%%", this.getMaxReduction(skillLevel) * 100.0));
        lore.add("Requires: Health below 50%");
        return lore;
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getScaledValue(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("Up to %.1f%% damage reduction", this.getMaxReduction(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        if (!this.isActive(player)) {
            return false;
        }
        return player.getHealth() / player.getMaxHealth() < 0.5;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return this.getScaledValue(skillLevel);
    }

    private double getMaxReduction(int skillLevel) {
        return 0.5 * this.getScaledValue(skillLevel);
    }

    public double modifyIncomingDamage(Player player, double originalDamage, Object context) {
        if (!this.conditionMet(player, context)) {
            return originalDamage;
        }
        int skillLevel = this.getPlayerSkillLevel(player);
        double healthPercent = player.getHealth() / player.getMaxHealth();
        double lowHealthMultiplier = (0.5 - healthPercent) / 0.5;
        double reduction = this.getMaxReduction(skillLevel) * lowHealthMultiplier;
        return originalDamage * (1.0 - reduction);
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.ARMOR);
    }
}

