/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.armor;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.StackingSkill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class FortifySkill
extends SkillBonus
implements StackingSkill {
    private static final HashSet<UUID> activePlayers = new HashSet();
    private static final Map<UUID, Integer> stackMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastDamageTime = new HashMap<UUID, Long>();
    private static final long STACK_DECAY_TIME = 10000L;

    public FortifySkill() {
        super(SkillType.ARMOR, 50, "Fortify", "Build damage reduction stacks when taking damage", SkillBonusType.STACKING, 3, "fortify");
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
    }

    @Override
    public void removeBonus(Player player) {
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        stackMap.remove(player.getUniqueId());
        lastDamageTime.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Build damage reduction stacks when taking damage");
        lore.add(String.format("Max Stacks: %d", this.getMaxStacks()));
        lore.add(String.format("Reduction per Stack: %.1f%%", this.getBonusPerStack(skillLevel) * 100.0));
        lore.add("Stacks decay after 10 seconds without damage");
        return lore;
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getBonusPerStack(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f%% reduction per stack (max %d)", this.getBonusPerStack(skillLevel) * 100.0, this.getMaxStacks());
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        stackMap.clear();
        lastDamageTime.clear();
    }

    @Override
    public int getMaxStacks() {
        return 5;
    }

    @Override
    public int getCurrentStacks(Player player) {
        if (!this.isActive(player)) {
            return 0;
        }
        Long lastDamage = lastDamageTime.get(player.getUniqueId());
        if (lastDamage != null && System.currentTimeMillis() - lastDamage > 10000L) {
            this.resetStacks(player);
        }
        return stackMap.getOrDefault(player.getUniqueId(), 0);
    }

    @Override
    public void addStack(Player player) {
        if (!this.isActive(player)) {
            return;
        }
        int current = stackMap.getOrDefault(player.getUniqueId(), 0);
        if (current < this.getMaxStacks()) {
            stackMap.put(player.getUniqueId(), current + 1);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)String.format("Fortify: %d/%d stacks", current + 1, this.getMaxStacks())));
        }
        lastDamageTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @Override
    public void resetStacks(Player player) {
        stackMap.remove(player.getUniqueId());
        lastDamageTime.remove(player.getUniqueId());
    }

    @Override
    public double getBonusPerStack(int skillLevel) {
        return 0.05 * this.getScaledValue(skillLevel);
    }

    public double modifyIncomingDamage(Player player, double originalDamage) {
        if (!this.isActive(player)) {
            return originalDamage;
        }
        int skillLevel = this.getPlayerSkillLevel(player);
        int currentStacks = this.getCurrentStacks(player);
        double reduction = (double)currentStacks * this.getBonusPerStack(skillLevel);
        double modifiedDamage = originalDamage * (1.0 - reduction);
        this.addStack(player);
        return modifiedDamage;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.ARMOR);
    }
}

