/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.armor;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class EvasionSkill
extends SkillBonus
implements ProcSkill {
    private static final HashSet<UUID> activePlayers = new HashSet();

    public EvasionSkill() {
        super(SkillType.ARMOR, 10, "Evasion", "Chance to completely dodge incoming attacks", SkillBonusType.PROC, 1, "evasion");
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
    }

    @Override
    public void removeBonus(Player player) {
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Chance to completely dodge incoming attacks");
        lore.add(String.format("Evasion Chance: %.1f%%", this.getProcChance(skillLevel) * 100.0));
        return lore;
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return 1.0;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f%% Evasion Chance", this.getProcChance(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }

    @Override
    public double getProcChance(int skillLevel) {
        return 0.1 + this.getScaledValue(skillLevel) * 0.05;
    }

    @Override
    public void onProc(Player player, Object context) {
        player.getWorld().spawnParticle(Particle.CLOUD, player.getLocation(), 10, 0.3, 0.5, 0.3, 0.05);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PHANTOM_FLAP, 0.5f, 1.5f);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"Evaded!"));
    }

    public boolean tryEvade(Player player, Object context) {
        if (!this.isActive(player)) {
            return false;
        }
        int skillLevel = this.getPlayerSkillLevel(player);
        if (ThreadLocalRandom.current().nextDouble() < this.getProcChance(skillLevel)) {
            this.onProc(player, context);
            return true;
        }
        return false;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.ARMOR);
    }
}

