/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses;

import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.elitemobs.skills.bonuses.PlayerSkillSelection;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class SkillBonusRegistry {
    private static final Map<SkillType, List<SkillBonus>> bonusesBySkill = new EnumMap<SkillType, List<SkillBonus>>(SkillType.class);
    private static final Map<String, SkillBonus> bonusesById = new HashMap<String, SkillBonus>();

    private SkillBonusRegistry() {
    }

    public static void registerBonus(SkillBonus bonus) {
        bonusesBySkill.computeIfAbsent(bonus.getSkillType(), k -> new ArrayList()).add(bonus);
        bonusesById.put(bonus.getSkillId(), bonus);
    }

    public static void unregisterBonus(SkillBonus bonus) {
        List<SkillBonus> bonuses = bonusesBySkill.get((Object)bonus.getSkillType());
        if (bonuses != null) {
            bonuses.remove(bonus);
        }
        bonusesById.remove(bonus.getSkillId());
    }

    public static SkillBonus getSkillById(String skillId) {
        return bonusesById.get(skillId);
    }

    public static List<SkillBonus> getBonuses(SkillType skillType) {
        return bonusesBySkill.getOrDefault((Object)skillType, Collections.emptyList());
    }

    public static List<SkillBonus> getEnabledBonuses(SkillType skillType) {
        return SkillBonusRegistry.getBonuses(skillType).stream().filter(SkillBonus::isEnabled).toList();
    }

    public static List<SkillBonus> getAllBonuses() {
        ArrayList<SkillBonus> all = new ArrayList<SkillBonus>();
        for (List<SkillBonus> bonusList : bonusesBySkill.values()) {
            all.addAll(bonusList);
        }
        return all;
    }

    public static List<SkillBonus> getAllEnabledBonuses() {
        return SkillBonusRegistry.getAllBonuses().stream().filter(SkillBonus::isEnabled).toList();
    }

    public static List<SkillBonus> getBonusesByTier(SkillType skillType, int unlockTier) {
        return SkillBonusRegistry.getBonuses(skillType).stream().filter(b -> b.getUnlockTier() == unlockTier).toList();
    }

    public static List<SkillBonus> getUnlockableBonuses(SkillType skillType, int skillLevel) {
        return SkillBonusRegistry.getEnabledBonuses(skillType).stream().filter(b -> b.canUnlock(skillLevel)).toList();
    }

    public static List<SkillBonus> getBonusesSortedByTier(SkillType skillType) {
        return SkillBonusRegistry.getBonuses(skillType).stream().sorted(Comparator.comparingInt(SkillBonus::getUnlockTier)).toList();
    }

    public static void applyBonuses(Player player, SkillType skillType) {
        int level = SkillBonusRegistry.getPlayerSkillLevel(player, skillType);
        List<String> activeSkillIds = PlayerSkillSelection.getActiveSkills(player.getUniqueId(), skillType);
        for (String skillId : activeSkillIds) {
            SkillBonus bonus = SkillBonusRegistry.getSkillById(skillId);
            if (bonus == null || !bonus.isEnabled() || !bonus.meetsLevelRequirement(level)) continue;
            bonus.applyBonus(player, level);
        }
    }

    public static void applyAllBonuses(Player player) {
        for (SkillType skillType : SkillType.values()) {
            SkillBonusRegistry.applyBonuses(player, skillType);
        }
    }

    public static void removeAllBonuses(Player player) {
        for (SkillBonus bonus : SkillBonusRegistry.getAllBonuses()) {
            if (!bonus.isActive(player)) continue;
            bonus.removeBonus(player);
        }
    }

    public static Map<String, Double> getTotalBonuses(Player player, SkillType skillType) {
        LinkedHashMap<String, Double> totals = new LinkedHashMap<String, Double>();
        int level = SkillBonusRegistry.getPlayerSkillLevel(player, skillType);
        List<String> activeSkillIds = PlayerSkillSelection.getActiveSkills(player.getUniqueId(), skillType);
        for (String skillId : activeSkillIds) {
            SkillBonus bonus = SkillBonusRegistry.getSkillById(skillId);
            if (bonus == null || !bonus.isEnabled() || !bonus.meetsLevelRequirement(level)) continue;
            totals.put(bonus.getBonusName(), bonus.getBonusValue(level));
        }
        return totals;
    }

    public static List<String> getFormattedBonuses(Player player, SkillType skillType) {
        ArrayList<String> formatted = new ArrayList<String>();
        int level = SkillBonusRegistry.getPlayerSkillLevel(player, skillType);
        List<String> activeSkillIds = PlayerSkillSelection.getActiveSkills(player.getUniqueId(), skillType);
        for (String skillId : activeSkillIds) {
            SkillBonus bonus = SkillBonusRegistry.getSkillById(skillId);
            if (bonus == null || !bonus.isEnabled() || !bonus.meetsLevelRequirement(level)) continue;
            formatted.add(bonus.getFormattedBonus(level));
        }
        return formatted;
    }

    public static int getSkillCount(SkillType skillType) {
        return SkillBonusRegistry.getBonuses(skillType).size();
    }

    public static int getEnabledSkillCount(SkillType skillType) {
        return SkillBonusRegistry.getEnabledBonuses(skillType).size();
    }

    public static int getPlayerSkillLevel(Player player, SkillType skillType) {
        long xp = PlayerData.getSkillXP(player.getUniqueId(), skillType);
        return SkillXPCalculator.levelFromTotalXP(xp);
    }

    public static void shutdown() {
        for (SkillBonus bonus : SkillBonusRegistry.getAllBonuses()) {
            bonus.shutdown();
        }
        bonusesBySkill.clear();
        bonusesById.clear();
    }

    public static void initializeSkillBonuses() {
    }
}

