/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.PlayerDamagedByEliteMobEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.PlayerSkillSelection;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkillBonusEventHandler
implements Listener {
    private static final Map<String, Set<UUID>> skillCooldowns = new HashMap<String, Set<UUID>>();
    private static final Map<UUID, Map<String, Integer>> playerStacks = new HashMap<UUID, Map<String, Integer>>();
    private static final Map<UUID, Set<String>> activeToggles = new HashMap<UUID, Set<String>>();

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEliteMobDamagedByPlayer(EliteMobDamagedByPlayerEvent event) {
        event.applySkillBonuses();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerDamagedByEliteMob(PlayerDamagedByEliteMobEvent event) {
        event.applySkillBonuses();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        new BukkitRunnable(this){

            public void run() {
                if (player.isOnline()) {
                    PlayerSkillSelection.onPlayerJoin(player);
                    SkillBonusRegistry.applyAllBonuses(player);
                }
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 40L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        PlayerSkillSelection.onPlayerLeave(player);
        SkillBonusRegistry.removeAllBonuses(player);
        playerStacks.remove(uuid);
        activeToggles.remove(uuid);
        for (Set<UUID> cooldownSet : skillCooldowns.values()) {
            cooldownSet.remove(uuid);
        }
    }

    public static boolean isOnCooldown(String skillId, UUID playerUUID) {
        Set<UUID> cooldownSet = skillCooldowns.get(skillId);
        return cooldownSet != null && cooldownSet.contains(playerUUID);
    }

    public static void startCooldown(final String skillId, final UUID playerUUID, int seconds) {
        Set cooldownSet = skillCooldowns.computeIfAbsent(skillId, k -> new HashSet());
        cooldownSet.add(playerUUID);
        new BukkitRunnable(){

            public void run() {
                SkillBonusEventHandler.endCooldown(skillId, playerUUID);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)seconds * 20L);
    }

    public static void endCooldown(String skillId, UUID playerUUID) {
        Set<UUID> cooldownSet = skillCooldowns.get(skillId);
        if (cooldownSet != null) {
            cooldownSet.remove(playerUUID);
        }
    }

    public static int getStacks(UUID playerUUID, String skillId) {
        Map<String, Integer> stacks = playerStacks.get(playerUUID);
        if (stacks == null) {
            return 0;
        }
        return stacks.getOrDefault(skillId, 0);
    }

    public static void setStacks(UUID playerUUID, String skillId, int count) {
        Map stacks = playerStacks.computeIfAbsent(playerUUID, k -> new HashMap());
        stacks.put(skillId, count);
    }

    public static void resetStacks(UUID playerUUID, String skillId) {
        Map<String, Integer> stacks = playerStacks.get(playerUUID);
        if (stacks != null) {
            stacks.remove(skillId);
        }
    }

    public static boolean isToggleActive(UUID playerUUID, String skillId) {
        Set<String> toggles = activeToggles.get(playerUUID);
        return toggles != null && toggles.contains(skillId);
    }

    public static void setToggle(UUID playerUUID, String skillId, boolean active) {
        Set toggles = activeToggles.computeIfAbsent(playerUUID, k -> new HashSet());
        if (active) {
            toggles.add(skillId);
        } else {
            toggles.remove(skillId);
        }
    }

    public static SkillType getWeaponSkillType(Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        if (mainHand == null || mainHand.getType() == Material.AIR) {
            return null;
        }
        Material type = mainHand.getType();
        String typeName = type.name();
        if (typeName.endsWith("_SWORD")) {
            return SkillType.SWORDS;
        }
        if (typeName.endsWith("_AXE")) {
            return SkillType.AXES;
        }
        if (type == Material.BOW) {
            return SkillType.BOWS;
        }
        if (type == Material.CROSSBOW) {
            return SkillType.CROSSBOWS;
        }
        if (type == Material.TRIDENT) {
            return SkillType.TRIDENTS;
        }
        if (typeName.endsWith("_HOE")) {
            return SkillType.HOES;
        }
        return null;
    }

    public static void shutdown() {
        skillCooldowns.clear();
        playerStacks.clear();
        activeToggles.clear();
        PlayerSkillSelection.shutdown();
    }
}

