/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses;

import com.magmaguy.elitemobs.config.skillbonuses.SkillBonusConfigFields;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.entity.Player;

public abstract class SkillBonus {
    protected final SkillType skillType;
    protected final int requiredLevel;
    protected final String bonusName;
    protected final String description;
    protected final SkillBonusType bonusType;
    protected final int unlockTier;
    protected final String skillId;
    protected boolean enabled = true;
    protected SkillBonusConfigFields configFields;
    private final Map<UUID, Integer> procCounts = new ConcurrentHashMap<UUID, Integer>();

    public void incrementProcCount(Player player) {
        this.procCounts.merge(player.getUniqueId(), 1, Integer::sum);
    }

    public int getProcCount(Player player) {
        return this.procCounts.getOrDefault(player.getUniqueId(), 0);
    }

    public void resetProcCount(Player player) {
        this.procCounts.remove(player.getUniqueId());
    }

    public void resetAllProcCounts() {
        this.procCounts.clear();
    }

    protected SkillBonus(SkillType skillType, int requiredLevel, String bonusName, String description, SkillBonusType bonusType, int unlockTier, String skillId) {
        this.skillType = skillType;
        this.requiredLevel = requiredLevel;
        this.bonusName = bonusName;
        this.description = description;
        this.bonusType = bonusType;
        this.unlockTier = unlockTier;
        this.skillId = skillId;
    }

    protected SkillBonus(SkillBonusConfigFields config) {
        this.configFields = config;
        this.skillType = config.getSkillType();
        this.requiredLevel = config.getRequiredLevel();
        this.bonusName = config.getName();
        this.description = String.join((CharSequence)" ", config.getDescription());
        this.bonusType = config.getBonusType();
        this.unlockTier = config.getUnlockTier();
        this.skillId = config.getSkillId();
        this.enabled = config.isEnabled();
    }

    public void setConfigFields(SkillBonusConfigFields configFields) {
        this.configFields = configFields;
        if (configFields != null) {
            this.enabled = configFields.isEnabled();
        }
    }

    public static int getLevelForTier(int tier) {
        return switch (tier) {
            case 1 -> 10;
            case 2 -> 25;
            case 3 -> 50;
            case 4 -> 75;
            default -> 100;
        };
    }

    public abstract void applyBonus(Player var1, int var2);

    public abstract void removeBonus(Player var1);

    public abstract void onActivate(Player var1);

    public abstract void onDeactivate(Player var1);

    public abstract boolean isActive(Player var1);

    public abstract List<String> getLoreDescription(int var1);

    public abstract double getBonusValue(int var1);

    public abstract String getFormattedBonus(int var1);

    public boolean meetsLevelRequirement(int skillLevel) {
        return skillLevel >= this.requiredLevel;
    }

    public boolean canUnlock(int skillLevel) {
        return skillLevel >= SkillBonus.getLevelForTier(this.unlockTier);
    }

    public void shutdown() {
        this.procCounts.clear();
    }

    protected double getScaledValue(Player player) {
        if (this.configFields == null) {
            return 1.0;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, this.skillType);
        return this.configFields.calculateValue(skillLevel);
    }

    protected double getScaledValue(int skillLevel) {
        if (this.configFields == null) {
            return 1.0;
        }
        return this.configFields.calculateValue(skillLevel);
    }

    protected double getScaledProcChance(Player player) {
        if (this.configFields == null) {
            return 0.1;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, this.skillType);
        return this.configFields.calculateProcChance(skillLevel);
    }

    protected double getScaledCooldown(Player player) {
        if (this.configFields == null) {
            return 30.0;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, this.skillType);
        return this.configFields.calculateCooldown(skillLevel);
    }

    @Generated
    public SkillType getSkillType() {
        return this.skillType;
    }

    @Generated
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Generated
    public String getBonusName() {
        return this.bonusName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public SkillBonusType getBonusType() {
        return this.bonusType;
    }

    @Generated
    public int getUnlockTier() {
        return this.unlockTier;
    }

    @Generated
    public String getSkillId() {
        return this.skillId;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public SkillBonusConfigFields getConfigFields() {
        return this.configFields;
    }
}

