/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills;

import com.magmaguy.elitemobs.skills.SkillType;

public class SkillXPCalculator {
    private SkillXPCalculator() {
    }

    public static long calculateMobXP(int mobLevel) {
        if (mobLevel <= 0) {
            return 0L;
        }
        return (long)mobLevel * (long)mobLevel;
    }

    public static long xpToNextLevel(int currentLevel) {
        if (currentLevel < 1) {
            currentLevel = 1;
        }
        long baseXP = 20L * (long)currentLevel * (long)currentLevel * (long)currentLevel;
        if (currentLevel <= 100) {
            return baseXP;
        }
        double softCapMultiplier = 1.0 + Math.pow(currentLevel - 100, 2.0) / 100.0;
        return (long)((double)baseXP * softCapMultiplier);
    }

    public static long totalXPForLevel(int targetLevel) {
        if (targetLevel <= 1) {
            return 0L;
        }
        long total = 0L;
        for (int level = 1; level < targetLevel; ++level) {
            total += SkillXPCalculator.xpToNextLevel(level);
        }
        return total;
    }

    public static int levelFromTotalXP(long totalXP) {
        if (totalXP <= 0L) {
            return 1;
        }
        int level = 1;
        long accumulatedXP = 0L;
        while (accumulatedXP + SkillXPCalculator.xpToNextLevel(level) <= totalXP) {
            accumulatedXP += SkillXPCalculator.xpToNextLevel(level);
            ++level;
        }
        return level;
    }

    public static long xpProgressInCurrentLevel(long totalXP) {
        if (totalXP <= 0L) {
            return 0L;
        }
        int currentLevel = SkillXPCalculator.levelFromTotalXP(totalXP);
        long xpForCurrentLevel = SkillXPCalculator.totalXPForLevel(currentLevel);
        return totalXP - xpForCurrentLevel;
    }

    public static double levelProgress(long totalXP) {
        int currentLevel = SkillXPCalculator.levelFromTotalXP(totalXP);
        long progressXP = SkillXPCalculator.xpProgressInCurrentLevel(totalXP);
        long requiredXP = SkillXPCalculator.xpToNextLevel(currentLevel);
        if (requiredXP == 0L) {
            return 0.0;
        }
        return (double)progressXP / (double)requiredXP;
    }

    public static long killsToNextLevel(int currentLevel, int mobLevel) {
        long xpNeeded = SkillXPCalculator.xpToNextLevel(currentLevel);
        long xpPerKill = SkillXPCalculator.calculateMobXP(mobLevel);
        if (xpPerKill == 0L) {
            return Long.MAX_VALUE;
        }
        return (xpNeeded + xpPerKill - 1L) / xpPerKill;
    }

    public static long calculateArmorXP(long baseXP) {
        return baseXP / 3L;
    }

    public static long applySkillMultiplier(SkillType skillType, long baseXP) {
        return (long)((double)baseXP * skillType.getXpMultiplier());
    }
}

